/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BMPString;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.TeletextString;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.UniversalString;

public interface DirectoryString
extends CharString {

    public static final class Factory {
        public static CharString createDirectoryString(Run _run) throws ParseException {
            byte tag = _run.get();
            switch (tag) {
                case 30: {
                    return new BMPString(_run);
                }
                case 19: {
                    return new PrintableString(_run);
                }
                case 20: {
                    return new TeletextString(_run);
                }
                case 28: {
                    return new UniversalString(_run);
                }
                case 12: {
                    return new UTF8String(_run);
                }
            }
            ANY any = new ANY(_run, false);
            throw new ParseException(any, "no representation for choice \"" + ASN1.Factory.toString(tag) + "\" (" + Hex.hexify(tag) + ") at index " + _run.pos(), _run.pos());
        }
    }
}

