/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlattableDumpablePublicKey;
import de.bos_bremen.ci.asn1.x509.DSAParameters;
import de.bos_bremen.ci.asn1.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DSAPublicKey
extends AbstractFlattableDumpablePublicKey
implements java.security.interfaces.DSAPublicKey {
    private static final long serialVersionUID = -5692544876765945455L;
    transient DSAParameters dsaParams;
    transient INTEGER y;

    public DSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws ParseException {
        super(subjectPublicKeyInfo);
    }

    @Override
    protected void initialize() throws ParseException {
        ANY parameters = this.subjectPublicKeyInfo.algorithm.getParameters();
        if (parameters != null && !(parameters instanceof DSAParameters)) {
            throw new ParseException(parameters, "DSAParameters expected", parameters.getOffset());
        }
        this.dsaParams = (DSAParameters)parameters;
        byte[] subjPubKeyBytes = this.subjectPublicKeyInfo.subjectPublicKey.getValueAsByteArray();
        this.y = new INTEGER(Run.create(new BSource(subjPubKeyBytes)));
    }

    @Override
    public DSAParams getParams() {
        return this.dsaParams;
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        if (this.dsaParams != null) {
            pairs.addAll(this.dsaParams.flatten(bundle, onlyShortList));
        }
        pairs.add(new Flattable.Pair(bundle.getString("general.publickey.dsa.parameters.y"), this.y.getValueAsHexedString()));
        return pairs;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.dsaParams != null) {
            this.dsaParams.dump(w);
            w.newLine();
        }
        w.write("y: " + this.y.getValueAsString());
        w.newLine();
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public BigInteger getY() {
        return this.y.getValue();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey other = (DSAPublicKey)o;
        if (other == this) {
            return true;
        }
        return this.getParams().equals(other.getParams()) && this.y.equals(other.y);
    }

    @Override
    public int hashCode() {
        return this.getParams().hashCode() ^ this.y.hashCode();
    }

    @Override
    public String toString() {
        return "DSAPublicKey[DSAParams=" + this.getParams() + ", Y=" + this.y + "]";
    }
}

