/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifierParameter;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DSAParameters
extends ANY
implements Dumpable,
Flattable,
DSAParams,
AlgorithmIdentifierParameter {
    INTEGER p;
    INTEGER q;
    INTEGER g;

    public DSAParameters(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.p = new INTEGER(_run);
        this.q = new INTEGER(_run);
        this.g = new INTEGER(_run);
    }

    @Override
    public BigInteger getP() {
        return this.p.getValue();
    }

    @Override
    public BigInteger getQ() {
        return this.q.getValue();
    }

    @Override
    public BigInteger getG() {
        return this.g.getValue();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("p: " + this.p.getValueAsString());
        w.newLine();
        w.write("q: " + this.q.getValueAsString());
        w.newLine();
        w.write("g: " + this.g.getValueAsString());
        w.newLine();
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(bundle.getString("general.publickey.dsa.parameters.p"), this.p.getValueAsHexedString()));
        pairs.add(new Flattable.Pair(bundle.getString("general.publickey.dsa.parameters.q"), this.q.getValueAsHexedString()));
        pairs.add(new Flattable.Pair(bundle.getString("general.publickey.dsa.parameters.g"), this.g.getValueAsHexedString()));
        return pairs;
    }
}

