/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlatCertificate;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.ExtensionFactory;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.JX509Certificate;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.TBSCertificate;
import de.bos_bremen.ci.asn1.x509.ext.KeyUsageExtension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class Certificate
extends AbstractFlatCertificate {
    TBSCertificate tbsCertificate;

    public Certificate(File _file) throws ParseException, IOException {
        this(new BSource(_file));
    }

    public Certificate(InputStream _is) throws ParseException, IOException {
        this(new BSource(_is));
    }

    public Certificate(Source _source) throws ParseException {
        this(Run.create(_source));
    }

    public Certificate(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.tbsCertificate = new TBSCertificate(_run);
        this.signatureAlgorithm = new AlgorithmIdentifier(_run);
        this.signature = new BITSTRING(_run);
    }

    public static Certificate forX509(X509Certificate _c) throws CertificateEncodingException, ParseException {
        if (_c == null) {
            return null;
        }
        if (_c instanceof JX509Certificate) {
            return ((JX509Certificate)_c).getDelegate();
        }
        return new Certificate(new BSource(_c.getEncoded()));
    }

    public static Certificate forX509(java.security.cert.Certificate _c) throws CertificateEncodingException, ParseException {
        if (_c == null) {
            return null;
        }
        if (_c instanceof JX509Certificate) {
            return ((JX509Certificate)_c).getDelegate();
        }
        return new Certificate(new BSource(_c.getEncoded()));
    }

    public TBSCertificate getTBSCertificate() {
        return this.tbsCertificate;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.tbsCertificate.dump(w);
        w.newLine();
        this.signatureAlgorithm.dump(w);
        w.newLine();
        w.write("Signature: ");
        w.write(this.signature.getValueAsString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public boolean hasCommonPKIrestrictions() {
        Extensions exts = this.getExtensions();
        if (exts == null) {
            return false;
        }
        for (String oid : ExtensionFactory.getCommonPKI_OIDs()) {
            Extension e = exts.get(oid);
            if (e == null) continue;
            return true;
        }
        return false;
    }

    private List<Extension> extractCommonPKIExtensions(List<Extension> _extensions) {
        Extensions exts = this.getExtensions();
        if (exts == null) {
            return Collections.emptyList();
        }
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (String oid : ExtensionFactory.getCommonPKI_OIDs()) {
            Extension e = exts.get(oid);
            if (e == null) continue;
            _extensions.remove(e);
            result.add(e);
        }
        return result;
    }

    @Override
    public List<Flattable.Pair> getOverviewPairs(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(res.getString("subjectdn"), this.getSubjectCommonName()));
        pairs.add(new Flattable.Pair(res.getString("issuerdn"), this.getIssuer().getDisplayName()));
        Date d = this.getNotAfter();
        if (d != null) {
            DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
            pairs.add(new Flattable.Pair(res.getString("general.validto"), sdf.format(d)));
        } else {
            pairs.add(new Flattable.Pair(res.getString("general.validto"), res.getString("na")));
        }
        if (this.hasCommonPKIrestrictions()) {
            pairs.add(new Flattable.Pair(null, res.getString("has.commonPKIExtensions")));
        }
        return pairs;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        void var8_14;
        void var8_11;
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(res.getString("subjectdn"), null));
        pairs.addAll(this.getSubject().flatten(res, false));
        pairs.add(new Flattable.Pair(null, null));
        pairs.add(new Flattable.Pair(res.getString("issuerdn"), null));
        pairs.addAll(this.getIssuer().flatten(res, false));
        pairs.add(new Flattable.Pair(null, null));
        Extensions exts = this.getExtensions();
        ArrayList<Extension> extensionList = new ArrayList<Extension>();
        if (exts != null) {
            extensionList.addAll(exts.getExtensions());
        }
        List<Object> commonPKIExtensions = new ArrayList();
        if (_short) {
            commonPKIExtensions = this.extractCommonPKIExtensions(extensionList);
        }
        if (!commonPKIExtensions.isEmpty()) {
            pairs.add(new Flattable.Pair(res.getString("extensions.commonPKI"), null));
            Collections.sort(commonPKIExtensions, ExtensionFactory.getCommonPKIComparator());
            for (Extension extension : commonPKIExtensions) {
                pairs.addAll(extension.flatten(res, false));
                pairs.add(new Flattable.Pair(null, null));
            }
        }
        pairs.add(new Flattable.Pair(res.getString("general"), null));
        if (!_short) {
            pairs.add(new Flattable.Pair(res.getString("general.type"), "X.509"));
            pairs.add(new Flattable.Pair(res.getString("general.version"), this.tbsCertificate.getVersion().getValue().toString()));
        }
        DateFormat sdf = FlattableUtil.newDateFormat(res, false);
        Date d = this.getNotBefore();
        if (d != null) {
            String string = sdf.format(d);
        } else {
            String string = this.getTBSCertificate().getValidity().getNotBeforeTime().getValueAsString();
        }
        pairs.add(new Flattable.Pair(res.getString("general.validfrom"), (String)var8_11));
        d = this.getNotAfter();
        if (d != null) {
            String string = sdf.format(d);
        } else {
            String string = this.getTBSCertificate().getValidity().getNotAfterTime().getValueAsString();
        }
        pairs.add(new Flattable.Pair(res.getString("general.validto"), (String)var8_14));
        pairs.add(new Flattable.Pair(res.getString("general.serialnumber"), this.getSerialNumber().getValueAsString()));
        pairs.add(new Flattable.Pair(null, this.getSerialNumber().getValueAsHexedString()));
        if (!_short) {
            pairs.addAll(this.tbsCertificate.getSubjectPublicKeyInfo().flatten(res, _short));
        } else {
            pairs.add(new Flattable.Pair(res.getString("general.signaturealgorithm"), this.tbsCertificate.getSignature().getAlgorithmName()));
        }
        pairs.add(new Flattable.Pair(null, null));
        if (!_short) {
            pairs.add(new Flattable.Pair(res.getString("issuersignature"), null));
            pairs.add(new Flattable.Pair(res.getString("general.signaturealgorithm"), this.tbsCertificate.getSignature().getAlgorithmName()));
            pairs.add(new Flattable.Pair(res.getString("general.signature"), this.signature.getValueAsString()));
            pairs.add(new Flattable.Pair(null, null));
        }
        if (!_short) {
            pairs.add(new Flattable.Pair(res.getString("fingerprint"), null));
            pairs.add(new Flattable.Pair("SHA-1", this.getHexedFingerprint("SHA-1", true)));
            pairs.add(new Flattable.Pair("MD5", this.getHexedFingerprint("MD5", true)));
            pairs.add(new Flattable.Pair(null, null));
        }
        if (!_short && !extensionList.isEmpty()) {
            pairs.add(new Flattable.Pair(res.getString("extensions"), null));
            ExtensionFactory.ExtComparator comparator = (ExtensionFactory.ExtComparator)ExtensionFactory.getComparator();
            if (comparator.hasOrder()) {
                Collections.sort(extensionList, comparator);
            }
            Iterator iterator = extensionList.iterator();
            while (iterator.hasNext()) {
                Extension ext = (Extension)iterator.next();
                pairs.addAll(ext.flatten(res, false));
                if (!iterator.hasNext()) continue;
                pairs.add(new Flattable.Pair(null, null));
            }
        }
        if (_short && !extensionList.isEmpty()) {
            for (Extension extension : extensionList) {
                if (!extension.getOID().equals("1.3.6.1.5.5.7.1.3")) continue;
                pairs.add(new Flattable.Pair(res.getString("extensions"), null));
                pairs.addAll(extension.flatten(res, false));
                break;
            }
        }
        return pairs;
    }

    @Override
    public Date getNotAfter() {
        return this.tbsCertificate.getValidity().getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.tbsCertificate.getValidity().getNotBefore();
    }

    @Override
    public String getIssuerCommonName() {
        return this.getIssuer().getCommonName();
    }

    @Override
    public String getSubjectCommonName() {
        return this.tbsCertificate.getSubject().getCommonName();
    }

    @Override
    public Name getSubject() {
        return this.tbsCertificate.getSubject();
    }

    @Override
    public Name getIssuer() {
        return this.tbsCertificate.getIssuer();
    }

    @Override
    public Extensions getExtensions() {
        return this.tbsCertificate.getExtensions();
    }

    @Override
    public CertificateSerialNumber getSerialNumber() {
        return this.tbsCertificate.getSerialNumber();
    }

    public boolean[] getKeyUsage() {
        Extensions exts = this.getExtensions();
        if (exts == null) {
            return null;
        }
        KeyUsageExtension e = (KeyUsageExtension)exts.get("2.5.29.15");
        if (e == null) {
            return null;
        }
        return e.getKeyUsage().getValue();
    }
}

