/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ENUMERATED;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class CRLReason
extends ENUMERATED
implements Dumpable {
    public static final int unspecified = 0;
    public static final int keyCompromise = 1;
    public static final int cACompromise = 2;
    public static final int affiliationChanged = 3;
    public static final int superseded = 4;
    public static final int cessationOfOperation = 5;
    public static final int certificateHold = 6;
    public static final int unused = 7;
    public static final int removeFromCRL = 8;
    public static final int privilegeWithdrawn = 9;
    public static final int aACompromise = 10;
    private final java.security.cert.CRLReason javaCRLReason;

    public CRLReason(Run _run) throws ParseException {
        this(_run, false);
    }

    public CRLReason(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        int value = this.getValueAsBigInteger().intValue();
        this.javaCRLReason = CRLReason.toJavaReason(value);
    }

    public static java.security.cert.CRLReason toJavaReason(int reasonCode) {
        java.security.cert.CRLReason tmpReason = null;
        for (java.security.cert.CRLReason reason : java.security.cert.CRLReason.values()) {
            if (reason.ordinal() != reasonCode) continue;
            tmpReason = reason;
            break;
        }
        if (tmpReason == null) {
            tmpReason = java.security.cert.CRLReason.UNUSED;
        }
        return tmpReason;
    }

    public java.security.cert.CRLReason getReason() {
        return this.javaCRLReason;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CRLReason[");
        sb.append(CRLReason.toString(this.getValueAsBigInteger().intValue()));
        sb.append(']');
        return sb.toString();
    }

    public static String toString(int flag) {
        switch (flag) {
            case 0: {
                return "unspecified";
            }
            case 1: {
                return "keyCompromise";
            }
            case 2: {
                return "cACompromise";
            }
            case 3: {
                return "affiliationChanged";
            }
            case 4: {
                return "superseded";
            }
            case 5: {
                return "cessationOfOperation";
            }
            case 6: {
                return "certificateHold";
            }
            case 9: {
                return "privilegeWithdrawn";
            }
            case 10: {
                return "aACompromise";
            }
        }
        return "unknown flag \"" + flag + "\"";
    }
}

