/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValue;
import de.bos_bremen.ci.asn1.x509.Name;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class AttributeTypeAndValueUtil {
    private static final char BACKSLASH = '\\';
    private static final List<Character> HEX_CHARS = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'));
    private static final String HEXSTRING_PREFIX = "#";
    private static final char QUOTATION = '\"';
    private static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf(','), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('#'), Character.valueOf(';'));
    private static final char TYPE_VALUE_SEPARATOR = '=';

    public static AttributeTypeAndValue fromRFC2253String(String ava) throws ParseException {
        int separatorPos = ava.indexOf(61);
        if (separatorPos == -1) {
            String msg = "AttributeTypeAndValue doesn't contain the type value separator (" + ava + ")";
            throw new ParseException(ava, msg, 0);
        }
        OBJECTIDENTIFIER type = AttributeTypeAndValueUtil.getTypeFor(ava, separatorPos);
        ANY value = AttributeTypeAndValueUtil.getValueFor(ava, separatorPos);
        return new AttributeTypeAndValue(type, value);
    }

    private static OBJECTIDENTIFIER getTypeFor(String ava, int separatorPos) throws ParseException {
        OBJECTIDENTIFIER oid;
        if (separatorPos == 0) {
            throw new ParseException(ava, "Empty type declaration (" + ava + ")", separatorPos);
        }
        String typeString = ava.substring(0, separatorPos).trim();
        if (typeString.startsWith("oid.") || typeString.startsWith("OID.")) {
            typeString = typeString.substring(4);
        }
        if ((oid = Name.getKnownOIDs().get(typeString)) == null) {
            oid = OBJECTIDENTIFIER.valueOf(typeString);
        }
        if (oid == null) {
            throw new ParseException(typeString, "unknown type : " + typeString, 0);
        }
        return oid;
    }

    private static ANY getValueFor(String ava, int separatorPos) throws ParseException {
        if (separatorPos == ava.length() - 1) {
            throw new ParseException(ava, "Type without value (" + ava + ")", separatorPos);
        }
        String valueString = ava.substring(separatorPos + 1);
        if ((valueString = AttributeTypeAndValueUtil.whitespaceTrim(valueString)).startsWith(HEXSTRING_PREFIX)) {
            String hexString = valueString.substring(1);
            Run run = Run.create(new BSource(Hex.parseHexString(hexString)));
            return ASN1.Factory.generate(run);
        }
        if (valueString.charAt(0) == '\"') {
            return AttributeTypeAndValueUtil.getUTF8StringForQuoted(valueString);
        }
        return AttributeTypeAndValueUtil.getUTF8StringFor(valueString);
    }

    private static String whitespaceTrim(String valueString) {
        while (valueString.length() > 0 && valueString.charAt(0) == ' ') {
            valueString = valueString.substring(1);
        }
        while (valueString.length() > 0 && valueString.charAt(valueString.length() - 1) == ' ' && (valueString.length() == 1 || valueString.charAt(valueString.length() - 2) != '\\')) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return valueString;
    }

    private static UTF8String getUTF8StringForQuoted(String valueString) throws ParseException {
        if (valueString.length() < 2 || valueString.charAt(0) != '\"' || valueString.charAt(valueString.length() - 1) != '\"') {
            throw new ParseException(valueString, "Double quotes expected at beginning and end of value string (" + valueString + ")", 0);
        }
        valueString = valueString.substring(1, valueString.length() - 1);
        for (int pos = 0; pos < valueString.length(); ++pos) {
            if (AttributeTypeAndValueUtil.isQuoteChar(valueString, pos)) continue;
            if (AttributeTypeAndValueUtil.isPair(valueString, pos)) {
                if (AttributeTypeAndValueUtil.isEscapedHexPair(valueString, pos)) {
                    valueString = AttributeTypeAndValueUtil.decodeFollowingEscapedHexPairs(valueString, pos);
                    continue;
                }
                valueString = valueString.substring(0, pos) + valueString.substring(pos + 1);
                continue;
            }
            throw new ParseException(valueString, "QuoteChar or Pair expected", pos);
        }
        return UTF8String.valueOf(valueString);
    }

    private static boolean isQuoteChar(String valueString, int pos) {
        char posChar = valueString.charAt(pos);
        return posChar != '\\' && posChar != '\"';
    }

    private static boolean isPair(String valueString, int pos) {
        if (valueString.charAt(pos) != '\\' || pos + 1 >= valueString.length()) {
            return false;
        }
        char c = valueString.charAt(pos + 1);
        return SPECIAL_CHARS.contains(Character.valueOf(c)) || c == '\\' || c == '\"' || AttributeTypeAndValueUtil.isEscapedHexPair(valueString, pos);
    }

    private static boolean isEscapedHexPair(String valueString, int pos) {
        if (valueString.charAt(pos) != '\\' || pos + 2 >= valueString.length()) {
            return false;
        }
        return HEX_CHARS.contains(Character.valueOf(valueString.charAt(pos + 1))) && HEX_CHARS.contains(Character.valueOf(valueString.charAt(pos + 2)));
    }

    private static String decodeFollowingEscapedHexPairs(String valueString, int pos) {
        int endPos = pos + 3;
        while (AttributeTypeAndValueUtil.isEscapedHexPair(valueString, endPos)) {
            endPos += 3;
        }
        String hex = valueString.substring(pos, endPos).replace("\\", "");
        String utf8 = new String(Hex.parseHexString(hex), Charset.forName("UTF-8"));
        return valueString.substring(0, pos) + utf8 + valueString.substring(endPos + 1);
    }

    private static UTF8String getUTF8StringFor(String valueString) throws ParseException {
        for (int pos = 0; pos < valueString.length(); ++pos) {
            if (pos + 1 < valueString.length() && valueString.charAt(pos) == '\\' && valueString.charAt(pos + 1) == ' ') {
                valueString = valueString.substring(0, pos) + valueString.substring(pos + 1);
                continue;
            }
            if (AttributeTypeAndValueUtil.isStringChar(valueString, pos)) continue;
            if (AttributeTypeAndValueUtil.isPair(valueString, pos)) {
                if (AttributeTypeAndValueUtil.isEscapedHexPair(valueString, pos)) {
                    valueString = AttributeTypeAndValueUtil.decodeFollowingEscapedHexPairs(valueString, pos);
                    continue;
                }
                valueString = valueString.substring(0, pos) + valueString.substring(pos + 1);
                continue;
            }
            throw new ParseException(valueString, "Expected stringchar or pair", pos);
        }
        return UTF8String.valueOf(valueString);
    }

    private static boolean isStringChar(String valueString, int pos) {
        char c = valueString.charAt(pos);
        return !SPECIAL_CHARS.contains(Character.valueOf(c)) && c != '\\' && c != '\"';
    }
}

