/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValueUtil;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.NameUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class AttributeTypeAndValue
extends ANY
implements Dumpable,
Flattable {
    OBJECTIDENTIFIER type;
    ANY value;

    public AttributeTypeAndValue(Run _run) throws ParseException {
        this(_run, false);
    }

    public AttributeTypeAndValue(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        byte tag = _run.next();
        if (!_implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() < end) {
            this.type = new OBJECTIDENTIFIER(_run);
            this.value = ASN1.Factory.generate(_run);
        }
    }

    AttributeTypeAndValue(String ava) throws ParseException {
        AttributeTypeAndValue fromRFC2253String = AttributeTypeAndValueUtil.fromRFC2253String(ava);
        this.type = fromRFC2253String.type;
        this.value = fromRFC2253String.value;
    }

    public AttributeTypeAndValue(OBJECTIDENTIFIER oid, ANY _value) {
        this.type = oid;
        this.value = _value;
    }

    public OBJECTIDENTIFIER getType() {
        return this.type;
    }

    public ANY getValue() {
        return this.value;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.type.toString());
        w.write(32);
        w.write(58);
        if (this.value instanceof Dumpable) {
            w.newLine();
            ((Dumpable)((Object)this.value)).dump(w);
        } else {
            w.write(32);
            w.write(this.value.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String key = this.type.getOID();
        try {
            key = res.getString(key);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.value instanceof Flattable) {
            result.addAll(((Flattable)((Object)this.value)).flatten(res, false));
        } else {
            result.add(new Flattable.Pair(key, this.value.toString()));
        }
        return result;
    }

    @Deprecated
    public ANY forOID(OBJECTIDENTIFIER _type, Run _run) throws ParseException {
        if (Name.POSTALADDRESS.equals(_type)) {
            byte tag = _run.next();
            if (tag != 48) {
                throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
            }
            StringBuilder result = new StringBuilder();
            int adEnd = _run.readLength();
            adEnd += _run.pos();
            while (_run.pos() < adEnd) {
                AbstractString line = (AbstractString)ASN1.Factory.generate(_run);
                result.append(line.getValue());
                if (_run.pos() >= adEnd) continue;
                result.append('\n');
            }
            return UTF8String.valueOf(result.toString());
        }
        ANY any = null;
        try {
            any = ASN1.Factory.generate(_run);
        }
        catch (ParseException ex) {
            any = new ANY(_run, false);
        }
        return any;
    }

    @Override
    public int getLength() {
        if (this.getSource() != null) {
            return super.getLength();
        }
        int result = 1;
        int length = this.type.getLength() + this.value.getLength();
        result += INTEGER.lengthLength(length);
        result += this.type.getLength();
        return result += this.value.getLength();
    }

    public String getAsDirectoryString() {
        StringBuilder sb = new StringBuilder();
        String oidName = NameUtil.getAbbreviation(this.type);
        sb.append(oidName);
        sb.append('=');
        if (this.value.toString().startsWith("ANY[")) {
            sb.append('#');
            sb.append(Hex.hexify(4));
            Run run = Run.create(this.value.getSource(), this.value.getOffset());
            byte[] bytes = run.next(this.value.getLength());
            INTEGER.writeLength(sb, bytes.length);
            sb.append(Hex.hexify(bytes, false, false));
        }
        sb.append(NameUtil.escapeRFC2253(this.value.getValueAsString()));
        return sb.toString();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        os.write(48);
        int length = this.type.getLength() + this.value.getLength();
        INTEGER.writeLength(os, length);
        this.type.encode(os);
        this.value.encode(os);
    }

    @Override
    public int hashCode() {
        return this.getAsDirectoryString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeTypeAndValue)) {
            return false;
        }
        AttributeTypeAndValue other = (AttributeTypeAndValue)obj;
        return this.getAsDirectoryString().equals(other.getAsDirectoryString());
    }

    @Override
    public String toString() {
        return this.getAsDirectoryString();
    }
}

