/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AttCertIssuer;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.Holder;
import de.bos_bremen.ci.asn1.x509.Subject;
import de.bos_bremen.ci.asn1.x509.UniqueIdentifier;
import de.bos_bremen.ci.asn1.x509.Validity;
import de.bos_bremen.ci.asn1.x509.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AttributeCertificateInfo
extends ANY
implements Dumpable {
    Subject subject;
    Version version;
    AttCertIssuer issuer;
    AlgorithmIdentifier signature;
    CertificateSerialNumber serialNumber;
    Validity attrCertValidityPeriod;
    List<Attribute> attributes;
    UniqueIdentifier issuerUniqueID;
    Extensions extensions;
    Holder holder;

    public AttributeCertificateInfo(Run _run) throws ParseException {
        super(_run, false);
        int l;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = l = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        this.version = tag == 2 ? new Version(_run) : new Version(0);
        if (this.version.getValue().intValue() == 2) {
            this.holder = new Holder(_run);
            this.subject = this.holder;
        } else {
            this.subject = Subject.Factory.generate(_run);
        }
        this.issuer = new AttCertIssuer(_run);
        this.signature = new AlgorithmIdentifier(_run);
        this.serialNumber = new CertificateSerialNumber(_run);
        this.attrCertValidityPeriod = new Validity(_run);
        tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int piEnd = _run.readLength();
        piEnd += _run.pos();
        this.attributes = new ArrayList<Attribute>();
        while (_run.pos() < piEnd) {
            Attribute attribute = new Attribute(_run);
            this.attributes.add(attribute);
        }
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 3) {
            this.issuerUniqueID = new UniqueIdentifier(_run, true);
            tag = _run.get();
        }
        if (_run.pos() >= end) {
            return;
        }
        if (tag == 48) {
            this.extensions = new Extensions(_run);
        }
    }

    public Holder getHolder() {
        return this.holder;
    }

    public Subject getSubject() {
        if (this.subject == null) {
            this.subject = this.holder.getEntityName() == null ? this.holder.getIssuerSerial() : this.holder.getEntityName();
        }
        return this.subject;
    }

    public GeneralNames getIssuer() {
        return this.issuer.getIssuer();
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(OBJECTIDENTIFIER oid) {
        if (oid == null) {
            return null;
        }
        for (Attribute att : this.attributes) {
            if (!oid.equals(att.getType())) continue;
            return att;
        }
        return null;
    }

    public Validity getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public UniqueIdentifier getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public CertificateSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.version.toString());
        w.newLine();
        this.subject.dump(w);
        w.newLine();
        this.issuer.dump(w);
        w.newLine();
        this.signature.dump(w);
        w.newLine();
        w.write(this.serialNumber.toString());
        w.newLine();
        this.attrCertValidityPeriod.dump(w);
        w.newLine();
        if (!this.attributes.isEmpty()) {
            Iterator<Attribute> iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Attribute attribute = iter.next();
                attribute.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
        }
        if (this.issuerUniqueID != null) {
            w.write(this.issuerUniqueID.toString());
            w.newLine();
        }
        if (this.extensions != null) {
            this.extensions.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

