/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlatCertificate;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.AttributeCertificateInfo;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.Subject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class AttributeCertificate
extends AbstractFlatCertificate {
    AttributeCertificateInfo acinfo;

    public AttributeCertificate(byte[] _bytes) throws ParseException, IOException {
        this(new BSource(_bytes));
    }

    public AttributeCertificate(File _file) throws ParseException, IOException {
        this(new BSource(_file));
    }

    public AttributeCertificate(InputStream _is) throws ParseException, IOException {
        this(new BSource(_is));
    }

    public AttributeCertificate(Source _source) throws ParseException {
        this(Run.create(_source));
    }

    public AttributeCertificate(Run _run) throws ParseException {
        this(_run, false);
    }

    public AttributeCertificate(Run _run, boolean implicit) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.acinfo = new AttributeCertificateInfo(_run);
        this.signatureAlgorithm = new AlgorithmIdentifier(_run);
        this.signature = new BITSTRING(_run);
    }

    public AttributeCertificateInfo getAttributeCertificateInfo() {
        return this.acinfo;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.acinfo.dump(w);
        w.newLine();
        this.signatureAlgorithm.dump(w);
        w.newLine();
        w.write(this.signature.toString());
        w.newLine();
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> getOverviewPairs(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(res.getString("subjectdn"), this.getSubjectCommonName()));
        pairs.add(new Flattable.Pair(res.getString("issuerdn"), this.getIssuer().getDisplayName()));
        Date d = this.getNotAfter();
        if (d != null) {
            DateFormat sdf = FlattableUtil.newDateFormat(res, false);
            pairs.add(new Flattable.Pair(res.getString("general.validto"), sdf.format(d)));
        } else {
            pairs.add(new Flattable.Pair(res.getString("general.validto"), res.getString("na")));
        }
        if (this.hasCommonPKIrestrictions()) {
            pairs.add(new Flattable.Pair(null, res.getString("has.commonPKIExtensions")));
        }
        Subject subject = this.getAttributeCertificateInfo().getSubject();
        String baseCertificateSCN = subject.getDisplayName();
        String baseCertificateSN = null;
        if (subject instanceof IssuerSerial) {
            IssuerSerial is = (IssuerSerial)subject;
            baseCertificateSN = is.getSerialnumber().getValueAsString();
        }
        String n = res.getString("baseCertificate.with" + (baseCertificateSN != null ? "" : "out") + ".sn");
        n = Hex.replace(n, "#", baseCertificateSCN);
        if (baseCertificateSN != null) {
            n = Hex.replace(n, "#", baseCertificateSN);
        }
        pairs.add(new Flattable.Pair(res.getString("baseCertificate.scn"), n));
        return pairs;
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        List<Flattable.Pair> flattenSubjectPairs = this.acinfo.subject.flatten(res, false);
        if (flattenSubjectPairs != null) {
            pairs.add(new Flattable.Pair(res.getString("subjectdn"), null));
            pairs.addAll(flattenSubjectPairs);
        }
        pairs.add(new Flattable.Pair(null, null));
        pairs.add(new Flattable.Pair(res.getString("issuerdn"), null));
        pairs.addAll(this.acinfo.issuer.flatten(res, false));
        pairs.add(new Flattable.Pair(null, null));
        if (this.acinfo.issuerUniqueID != null) {
            pairs.add(new Flattable.Pair(res.getString("issuer.unique.id"), this.acinfo.issuerUniqueID.getValueAsString()));
        }
        pairs.add(new Flattable.Pair(res.getString("general"), null));
        pairs.add(new Flattable.Pair(res.getString("general.type"), "X.509"));
        pairs.add(new Flattable.Pair(res.getString("general.version"), this.acinfo.version.getValue().toString()));
        pairs.addAll(this.acinfo.attrCertValidityPeriod.flatten(res, false));
        BigInteger sn = this.acinfo.serialNumber.getValue();
        pairs.add(new Flattable.Pair(res.getString("general.serialnumber"), sn.toString()));
        pairs.add(new Flattable.Pair(null, Hex.hexify(sn.toByteArray())));
        pairs.add(new Flattable.Pair(null, null));
        boolean hasAttributes = false;
        for (Attribute attribute : this.acinfo.attributes) {
            hasAttributes = attribute.type != null;
            if (!hasAttributes) continue;
            break;
        }
        if (hasAttributes) {
            pairs.add(new Flattable.Pair(res.getString("attributes"), null));
            for (Attribute attribute : this.acinfo.attributes) {
                pairs.addAll(attribute.flatten(res, false));
            }
            pairs.add(new Flattable.Pair(null, null));
        }
        pairs.add(new Flattable.Pair(res.getString("issuersignature"), null));
        pairs.add(new Flattable.Pair(res.getString("general.signaturealgorithm"), this.acinfo.signature.getAlgorithmName()));
        pairs.add(new Flattable.Pair(res.getString("general.signature"), this.signature.getValueAsString()));
        pairs.add(new Flattable.Pair(null, null));
        pairs.add(new Flattable.Pair(res.getString("fingerprint"), null));
        pairs.add(new Flattable.Pair("SHA-1", this.getHexedFingerprint("SHA-1", true)));
        pairs.add(new Flattable.Pair("MD5", this.getHexedFingerprint("MD5", true)));
        pairs.add(new Flattable.Pair(null, null));
        if (this.acinfo.getExtensions() != null) {
            pairs.addAll(this.acinfo.getExtensions().flatten(res, false));
        }
        return pairs;
    }

    @Override
    public Date getNotAfter() {
        return this.acinfo.attrCertValidityPeriod.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.acinfo.attrCertValidityPeriod.getNotBefore();
    }

    @Override
    public String getIssuerCommonName() {
        return this.acinfo.issuer.getIssuer().getDisplayName();
    }

    @Override
    public String getSubjectCommonName() {
        return this.acinfo.subject.getDisplayName();
    }

    @Override
    public Extensions getExtensions() {
        return this.acinfo.getExtensions();
    }

    @Override
    public CertificateSerialNumber getSerialNumber() {
        return this.acinfo.serialNumber;
    }

    public boolean isBase(FlatCertificate _base) {
        return this.acinfo.subject.matches(_base);
    }

    @Override
    public Name getIssuer() {
        return this.acinfo.issuer.getIssuer().getName();
    }

    @Override
    public Name getSubject() {
        return this.acinfo.subject.getName();
    }

    public boolean verify(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature sig = Signature.getInstance(this.signatureAlgorithm.getJCAName());
        sig.initVerify(publicKey);
        sig.update(this.acinfo.asByteArray());
        return sig.verify(this.signature.getValueAsByteArray());
    }

    @Override
    public boolean hasCommonPKIrestrictions() {
        return false;
    }
}

