/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.cms.ArchiveTimestamp;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.bos_bremen.ci.asn1.cms.CertificateValues;
import de.bos_bremen.ci.asn1.cms.CompleteCertificateRefs;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.er.EvidenceRecord;
import de.bos_bremen.ci.asn1.esf.CompleteRevocationRefs;
import de.bos_bremen.ci.asn1.ocsp.RevocationValues;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.x509.AdmissionSyntax;
import de.bos_bremen.ci.asn1.x509.CertGenerationDateSyntax;
import de.bos_bremen.ci.asn1.x509.DeclarationOfMajoritySyntax;
import de.bos_bremen.ci.asn1.x509.ICCSNSyntax;
import de.bos_bremen.ci.asn1.x509.MonetaryLimitSyntax;
import de.bos_bremen.ci.asn1.x509.ProcurationSyntax;
import de.bos_bremen.ci.asn1.x509.RestrictionSyntax;
import java.io.IOException;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class Attribute
extends ANY
implements Dumpable,
Flattable {
    public static final OBJECTIDENTIFIER CONTENT_TIME_STAMP = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.20");
    public static final OBJECTIDENTIFIER COUNTER_SIGNATURE = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.6");
    public static final OBJECTIDENTIFIER id_sigi_at_admission = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.3");
    public static final OBJECTIDENTIFIER id_sigi_at_dateOfCertGen = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.1");
    public static final OBJECTIDENTIFIER id_sigi_at_declarationOfMajority = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.5");
    public static final OBJECTIDENTIFIER id_sigi_at_ICCSN = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.6");
    public static final OBJECTIDENTIFIER id_sigi_at_monetaryLimit = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.4");
    public static final OBJECTIDENTIFIER id_sigi_at_pKReference = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.7");
    public static final OBJECTIDENTIFIER id_sigi_at_procuration = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.2");
    public static final OBJECTIDENTIFIER id_sigi_at_restriction = OBJECTIDENTIFIER.valueOf("1.3.36.8.3.8");
    public static final OBJECTIDENTIFIER REVOCATION_REFS = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.22");
    public static final OBJECTIDENTIFIER REVOCATION_VALUES = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.24");
    public static final OBJECTIDENTIFIER CERTIFICATE_REFS = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.21");
    public static final OBJECTIDENTIFIER CERT_VALUES = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.23");
    public static final OBJECTIDENTIFIER ESC_TIMESTAMP_TOKEN = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.25");
    public static final OBJECTIDENTIFIER CERTCRLTIMESTAMP = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.26");
    public static final OBJECTIDENTIFIER SIGNATURE_TIME_STAMP = ContentType.id_aa_timeStampToken;
    public static final OBJECTIDENTIFIER ARCHIVE_TIMESTAMP_V1 = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.27");
    public static final OBJECTIDENTIFIER ARCHIVE_TIMESTAMP_V2 = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.48");
    public static final OBJECTIDENTIFIER ARCHIVE_TIMESTAMP_V3 = OBJECTIDENTIFIER.valueOf("0.4.0.1733.2.4");
    public static final OBJECTIDENTIFIER ATS_HASH_INDEX_V3 = OBJECTIDENTIFIER.valueOf("0.4.0.19122.1.5");
    public static final OBJECTIDENTIFIER ATS_HASH_INDEX_V2 = OBJECTIDENTIFIER.valueOf("0.4.0.19122.1.4");
    public static final OBJECTIDENTIFIER ATS_HASH_INDEX_V1 = OBJECTIDENTIFIER.valueOf("0.4.0.1733.2.5");
    public static final OBJECTIDENTIFIER ID_AA_ER_INTERNAL = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.49");
    public static final OBJECTIDENTIFIER ID_AA_ER_EXTERNAL = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.50");
    protected OBJECTIDENTIFIER type;
    protected Set<ANY> values;

    public static String nameFor(OBJECTIDENTIFIER oid) {
        if (id_sigi_at_dateOfCertGen.equals(oid)) {
            return "id_sigi_at_dateOfCertGen";
        }
        if (id_sigi_at_procuration.equals(oid)) {
            return "id_sigi_at_procuration";
        }
        if (id_sigi_at_admission.equals(oid)) {
            return "id_sigi_at_admission";
        }
        if (id_sigi_at_monetaryLimit.equals(oid)) {
            return "id_sigi_at_monetaryLimit";
        }
        if (id_sigi_at_declarationOfMajority.equals(oid)) {
            return "id_sigi_at_declarationOfMajority";
        }
        if (id_sigi_at_ICCSN.equals(oid)) {
            return "id_sigi_at_ICCSN";
        }
        if (id_sigi_at_pKReference.equals(oid)) {
            return "id_sigi_at_pKReference";
        }
        if (id_sigi_at_restriction.equals(oid)) {
            return "id_sigi_at_restriction";
        }
        if (CONTENT_TIME_STAMP.equals(oid)) {
            return "id-aa-ets-contentTimestamp";
        }
        if (SIGNATURE_TIME_STAMP.equals(oid)) {
            return "id-aa-signatureTimeStampToken";
        }
        if (REVOCATION_VALUES.equals(oid)) {
            return "id-aa-ets-revocationValues";
        }
        if (REVOCATION_REFS.equals(oid)) {
            return "id-aa-ets-revocationRefs";
        }
        if (CERT_VALUES.equals(oid)) {
            return "id-aa-ets-certValues";
        }
        if (CERTIFICATE_REFS.equals(oid)) {
            return "id-aa-ets-certitificateRefs";
        }
        if (ARCHIVE_TIMESTAMP_V3.equals(oid)) {
            return "id-aa-ets-archiveTimestampV3";
        }
        if (ARCHIVE_TIMESTAMP_V2.equals(oid)) {
            return "id-aa-ets-archiveTimestampV2";
        }
        if (ARCHIVE_TIMESTAMP_V1.equals(oid)) {
            return "id-aa-ets-archiveTimeStamp";
        }
        if (ATS_HASH_INDEX_V3.equals(oid)) {
            return "ats-hash-index-v3";
        }
        if (ATS_HASH_INDEX_V2.equals(oid)) {
            return "ats-hash-index-v2";
        }
        if (ATS_HASH_INDEX_V1.equals(oid)) {
            return "ats-hash-index";
        }
        if (ID_AA_ER_INTERNAL.equals(oid)) {
            return "id-aa-er-internal";
        }
        if (ID_AA_ER_EXTERNAL.equals(oid)) {
            return "id-aa-er-external";
        }
        if (COUNTER_SIGNATURE.equals(oid)) {
            return "id-countersignature";
        }
        if (ESC_TIMESTAMP_TOKEN.equals(oid)) {
            return "id-aa-ets-escTimeStamp";
        }
        if (CERTCRLTIMESTAMP.equals(oid)) {
            return "id-aa-ets-certCRLTimestamp";
        }
        return "unknown (" + oid + ")";
    }

    public Attribute(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() < end) {
            this.type = new OBJECTIDENTIFIER(_run);
            this.values = new HashSet<ANY>();
            tag = _run.next();
            if (tag != 49) {
                throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
            }
            int vEnd = _run.readLength();
            vEnd += _run.pos();
            while (_run.pos() < vEnd) {
                this.values.add(this.forOID(this.type, _run));
            }
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(Attribute.nameFor(this.type) + " (" + this.type.toString() + ")");
        w.write(32);
        w.write(58);
        w.indent();
        w.newLine();
        Iterator<ANY> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            ANY any = iterator.next();
            if (any instanceof Dumpable) {
                Dumpable d = (Dumpable)((Object)any);
                d.dump(w);
            } else {
                w.write(any.toString());
            }
            if (!iterator.hasNext()) continue;
            w.newLine();
        }
        w.outdent();
        w.newLine();
        w.outdent();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String oid = this.type.getOID();
        try {
            oid = res.getString(oid);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ANY> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            ANY any = iterator.next();
            if (any instanceof AbstractString) {
                sb.append(((AbstractString)any).getValue());
            } else if (any instanceof Time) {
                DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
                sb.append(sdf.format(((Time)((Object)any)).getDate()));
            } else if (any instanceof Flattable) {
                result.addAll(((Flattable)((Object)any)).flatten(res, false));
                oid = null;
            } else {
                sb.append(any.getValueAsString());
            }
            if (!iterator.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        if (oid != null) {
            result.add(new Flattable.Pair(oid, sb.toString()));
        }
        return result;
    }

    public ANY forOID(OBJECTIDENTIFIER oid, Run _run) throws ParseException {
        if (id_sigi_at_dateOfCertGen.equals(oid)) {
            return new CertGenerationDateSyntax(_run);
        }
        if (id_sigi_at_procuration.equals(oid)) {
            return new ProcurationSyntax(_run);
        }
        if (id_sigi_at_admission.equals(oid)) {
            return new AdmissionSyntax(_run);
        }
        if (id_sigi_at_monetaryLimit.equals(oid)) {
            return new MonetaryLimitSyntax(_run);
        }
        if (id_sigi_at_declarationOfMajority.equals(oid)) {
            return new DeclarationOfMajoritySyntax(_run);
        }
        if (id_sigi_at_ICCSN.equals(oid)) {
            return new ICCSNSyntax(_run);
        }
        if (id_sigi_at_pKReference.equals(oid)) {
            return new ANY(_run, false);
        }
        if (id_sigi_at_restriction.equals(oid)) {
            return new RestrictionSyntax(_run);
        }
        if (CONTENT_TIME_STAMP.equals(oid)) {
            return new SignatureTimeStampToken(_run);
        }
        if (SIGNATURE_TIME_STAMP.equals(oid)) {
            return new SignatureTimeStampToken(_run);
        }
        if (REVOCATION_VALUES.equals(oid)) {
            return new RevocationValues(_run);
        }
        if (REVOCATION_REFS.equals(oid)) {
            return new CompleteRevocationRefs(_run);
        }
        if (CERT_VALUES.equals(oid)) {
            return new CertificateValues(_run, false);
        }
        if (CERTIFICATE_REFS.equals(oid)) {
            return new CompleteCertificateRefs(_run, false);
        }
        if (COUNTER_SIGNATURE.equals(oid)) {
            return new SignerInfo(_run);
        }
        if (ESC_TIMESTAMP_TOKEN.equals(oid)) {
            return new SignatureTimeStampToken(_run);
        }
        if (CERTCRLTIMESTAMP.equals(oid)) {
            return new SignatureTimeStampToken(_run);
        }
        if (ARCHIVE_TIMESTAMP_V3.equals(oid)) {
            return new ArchiveTimestamp(_run, 3);
        }
        if (ARCHIVE_TIMESTAMP_V2.equals(oid)) {
            return new ArchiveTimestamp(_run, 2);
        }
        if (ARCHIVE_TIMESTAMP_V1.equals(oid)) {
            return new ArchiveTimestamp(_run, 1);
        }
        if (ATS_HASH_INDEX_V3.equals(oid)) {
            return new AtsHashIndex(_run, 3);
        }
        if (ATS_HASH_INDEX_V2.equals(oid)) {
            return new AtsHashIndex(_run, 2);
        }
        if (ATS_HASH_INDEX_V1.equals(oid)) {
            return new AtsHashIndex(_run, 1);
        }
        if (ID_AA_ER_INTERNAL.equals(oid)) {
            return new EvidenceRecord(_run, true);
        }
        if (ID_AA_ER_EXTERNAL.equals(oid)) {
            return new EvidenceRecord(_run, false);
        }
        return ASN1.Factory.generate(_run);
    }

    public OBJECTIDENTIFIER getObjectID() {
        return this.type;
    }

    public String getOID() {
        return this.type.getOID();
    }

    public OBJECTIDENTIFIER getType() {
        return this.type;
    }

    public List<ANY> getValues() {
        return new ArrayList<ANY>(this.values);
    }

    @Override
    public String toString() {
        List<Flattable.Pair> pairs = this.flatten(ResourceBundle.getBundle(Flattable.class.getName()), false);
        int indent = 0;
        for (Flattable.Pair pair : pairs) {
            if (pair.label == null) continue;
            indent = Math.max(pair.label.length(), indent);
        }
        StringWriter w = new StringWriter();
        Iterator<Flattable.Pair> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Flattable.Pair pair = iterator.next();
            w.write(pair.toString(indent));
            if (!iterator.hasNext()) continue;
            w.write(10);
        }
        return w.toString();
    }
}

