/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class AttCertIssuer
extends ANY
implements Dumpable,
Flattable {
    private int formVersion = 0;
    private IssuerSerial baseCertificateID;
    private GeneralNames issuer;

    public AttCertIssuer(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.get();
        if (ASN1.Factory.isTagged(tag)) {
            this.formVersion = 2;
            if (!ASN1.Factory.isTaggedAs(tag, 0)) {
                throw new ParseException(this, ASN1.Factory.toString((byte)-128) + "(0) expected at index " + _run.pos(), _run.pos());
            }
            _run.next();
            int l = _run.readLength();
            this.setEnd(_run.pos() + l);
            tag = _run.get();
            if (tag == 48) {
                this.issuer = new GeneralNames(_run);
            }
            tag = _run.get();
        } else {
            this.formVersion = 1;
            if (tag != 48) {
                throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + ", found byte: " + tag, _run.pos());
            }
            this.issuer = new GeneralNames(_run);
            this.setEnd(this.issuer.getEnd());
        }
    }

    public int getFormVersion() {
        return this.formVersion;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (this.baseCertificateID != null || this.issuer != null) {
            w.indent();
            w.newLine();
            if (this.baseCertificateID != null) {
                this.baseCertificateID.dump(w);
                if (this.issuer != null) {
                    w.newLine();
                }
            }
            if (this.issuer != null) {
                this.issuer.dump(w);
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.baseCertificateID != null) {
            result.addAll(this.baseCertificateID.flatten(bundle, onlyShortList));
        }
        if (this.issuer != null) {
            result.addAll(this.issuer.flatten(bundle, onlyShortList));
        }
        return result;
    }
}

