/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AdmissionAuthority;
import de.bos_bremen.ci.asn1.x509.NamingAuthority;
import de.bos_bremen.ci.asn1.x509.ProfessionInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class Admissions
extends ANY
implements Dumpable,
Flattable {
    AdmissionAuthority admissionAuthority;
    NamingAuthority namingAuthority;
    List<ProfessionInfo> professionInfos;

    public Admissions(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.next();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.readLength();
            this.admissionAuthority = AdmissionAuthority.Factory.generate(_run);
            tag = _run.next();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            _run.readLength();
            this.namingAuthority = new NamingAuthority(_run);
            tag = _run.next();
        }
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.professionInfos = new ArrayList<ProfessionInfo>();
        int end2 = _run.readLength();
        end2 += _run.pos();
        while (_run.pos() < end2) {
            ProfessionInfo professionInfo = new ProfessionInfo(_run);
            this.professionInfos.add(professionInfo);
        }
    }

    public AdmissionAuthority getAdmissionAuthority() {
        return this.admissionAuthority;
    }

    public NamingAuthority getNamingAuthority() {
        return this.namingAuthority;
    }

    public List<ProfessionInfo> getProfessionInfos() {
        return this.professionInfos;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.admissionAuthority != null) {
            this.admissionAuthority.dump(w);
            w.newLine();
        }
        if (this.namingAuthority != null) {
            this.namingAuthority.dump(w);
            w.newLine();
        }
        Iterator<ProfessionInfo> iter = this.professionInfos.iterator();
        while (iter.hasNext()) {
            ProfessionInfo professionInfo = iter.next();
            professionInfo.dump(w);
            if (!iter.hasNext()) continue;
            w.newLine();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(null, null));
        result.add(new Flattable.Pair(res.getString("admission_entry"), ""));
        if (this.admissionAuthority != null) {
            result.add(new Flattable.Pair(res.getString("admission_authority"), ""));
            result.addAll(this.admissionAuthority.flatten(res, false));
            if (this.namingAuthority != null) {
                result.add(new Flattable.Pair(null, null));
            }
        }
        if (this.namingAuthority != null) {
            result.add(new Flattable.Pair(res.getString("naming_authority"), ""));
            result.addAll(this.namingAuthority.flatten(res, false));
        }
        for (ProfessionInfo professionInfo : this.professionInfos) {
            result.addAll(professionInfo.flatten(res, false));
        }
        return result;
    }
}

