/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AdmissionAuthority;
import de.bos_bremen.ci.asn1.x509.Admissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class AdmissionSyntax
extends ANY
implements Flattable {
    AdmissionAuthority admissionAuthority;
    List<Admissions> contentsOfAdmissions;

    public AdmissionSyntax(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (tag != 48) {
            this.admissionAuthority = AdmissionAuthority.Factory.generate(_run);
            tag = _run.get();
        }
        if (tag != 48) {
            throw new ParseException(this, "no sequence declaration", _run.pos());
        }
        _run.next();
        this.contentsOfAdmissions = new ArrayList<Admissions>();
        int end2 = _run.readLength();
        end2 += _run.pos();
        while (_run.pos() < end2) {
            Admissions admissions = new Admissions(_run);
            this.contentsOfAdmissions.add(admissions);
        }
    }

    public AdmissionAuthority getAdmissionAuthority() {
        return this.admissionAuthority;
    }

    public List<Admissions> getAdmissions() {
        return this.contentsOfAdmissions;
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.admissionAuthority != null) {
            this.admissionAuthority.dump(w);
            w.newLine();
        }
        Iterator<Admissions> iter = this.contentsOfAdmissions.iterator();
        while (iter.hasNext()) {
            Admissions admissions = iter.next();
            admissions.dump(w);
            if (!iter.hasNext()) continue;
            w.newLine();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.admissionAuthority != null) {
            result.add(new Flattable.Pair(null, null));
            result.add(new Flattable.Pair(res.getString("admission_authority"), ""));
            result.addAll(this.admissionAuthority.flatten(res, false));
        }
        for (Admissions admissions : this.contentsOfAdmissions) {
            result.addAll(admissions.flatten(res, false));
        }
        return result;
    }
}

