/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AccessDescription
extends ANY
implements Dumpable,
Flattable {
    public static final OBJECTIDENTIFIER id_pkix = OBJECTIDENTIFIER.valueOf("1.3.6.1.5.5.7");
    public static final OBJECTIDENTIFIER id_ad = OBJECTIDENTIFIER.valueOf(id_pkix + ".48");
    public static final OBJECTIDENTIFIER id_ad_ocsp = OBJECTIDENTIFIER.valueOf(id_ad + ".1");
    public static final OBJECTIDENTIFIER id_ad_caIssuer = OBJECTIDENTIFIER.valueOf(id_ad + ".2");
    OBJECTIDENTIFIER accessMethod;
    GeneralName accessLocation;

    public AccessDescription(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.accessMethod = new OBJECTIDENTIFIER(_run);
        this.accessLocation = GeneralName.Factory.generate(_run, true);
    }

    public boolean isOCSP() {
        return id_ad_ocsp.equals(this.accessMethod);
    }

    public OBJECTIDENTIFIER getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getLocation() {
        return this.accessLocation;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("accessMethod : ");
        w.write(this.accessMethod.toString());
        w.newLine();
        this.accessLocation.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String value = this.accessMethod.getOID();
        try {
            value = res.getString(this.accessMethod.getOID());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        result.add(new Flattable.Pair(res.getString("accessMethod"), value));
        result.addAll(this.accessLocation.flatten(res, false));
        return result;
    }

    public static String nameFor(OBJECTIDENTIFIER _oid) {
        if (id_ad_ocsp.equals(_oid)) {
            return "id_ad_ocsp";
        }
        return "id_ad_caIssuer";
    }
}

