/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.QLevel;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.ext.CertGenerationDateExtension;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class AbstractFlatCertificate
extends ANY
implements Dumpable,
FlatCertificate {
    AlgorithmIdentifier signatureAlgorithm;
    BITSTRING signature;

    protected AbstractFlatCertificate(Run run, boolean implicit) {
        super(run, implicit);
    }

    @Override
    public byte[] getEncoded() {
        Run run = Run.create(this.getSource(), this.getOffset());
        return run.next(this.getLength());
    }

    @Override
    public Date getGenerationTime() {
        CertGenerationDateExtension ext;
        if (this.getExtensions() != null && (ext = (CertGenerationDateExtension)this.getExtensions().get("1.3.36.8.3.1")) != null) {
            return ext.getDate();
        }
        return this.getNotBefore();
    }

    @Override
    public final QLevel getQLevel() {
        return QLevel.UNKNOWN;
    }

    @Override
    public BITSTRING getSignature() {
        return this.signature;
    }

    @Override
    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public long remainingDaysValid(Date ref) {
        if (ref == null) {
            ref = new Date();
        }
        long l = this.getNotAfter().getTime() - ref.getTime();
        l /= 1000L;
        l /= 60L;
        l /= 60L;
        return l /= 24L;
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle(Flattable.class.getName(), Locale.getDefault());
        List<Flattable.Pair> pairs = this.flatten(bundle, false);
        int indent = 0;
        for (Flattable.Pair pair : pairs) {
            if (pair.label == null) continue;
            indent = Math.max(pair.label.length(), indent);
        }
        StringWriter w = new StringWriter();
        Iterator<Flattable.Pair> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Flattable.Pair pair = iterator.next();
            w.write(pair.toString(indent));
            if (!iterator.hasNext()) continue;
            w.write(10);
        }
        return w.toString();
    }
}

