/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.FSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.PKIStatusInfo;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.tsp.TimeStampToken;
import java.io.File;
import java.io.IOException;

public class TimeStampResp
extends ANY
implements Dumpable {
    PKIStatusInfo status;
    TimeStampToken timeStampToken;

    public TimeStampResp(File _file) throws ParseException {
        this(new FSource(_file));
    }

    public TimeStampResp(Source _source) throws ParseException {
        this(Run.create(_source));
    }

    private TimeStampResp(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.status = new PKIStatusInfo(_run);
        if (_run.pos() < end) {
            this.timeStampToken = new SignatureTimeStampToken(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.status.dump(w);
        if (this.timeStampToken != null) {
            w.newLine();
            this.timeStampToken.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }
}

