/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.Accuracy;
import de.bos_bremen.ci.asn1.tsp.MessageImprint;
import de.bos_bremen.ci.asn1.tsp.TSAPolicyId;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import java.io.IOException;
import java.text.SimpleDateFormat;

public class TSTInfo
extends ANY
implements Dumpable {
    INTEGER version;
    TSAPolicyId policy;
    MessageImprint messageImprint;
    INTEGER serialNumber;
    GeneralizedTime genTime;
    Accuracy accuracy;
    BOOLEAN ordering;
    INTEGER nonce;
    GeneralName tsa;
    Extensions extensions;

    public TSTInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (!this.implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.version = new INTEGER(_run);
        this.policy = new TSAPolicyId(_run);
        this.messageImprint = new MessageImprint(_run);
        this.serialNumber = new INTEGER(_run);
        this.genTime = new GeneralizedTime(_run);
        tag = _run.get();
        if (tag == 48) {
            this.accuracy = new Accuracy(_run);
            tag = _run.get();
        }
        BOOLEAN bOOLEAN = this.ordering = tag == 1 ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 2) {
            this.nonce = new INTEGER(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.tsa = GeneralName.Factory.generate(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            this.extensions = new Extensions(_run, true);
        }
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public TSAPolicyId getPolicy() {
        return this.policy;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public GeneralizedTime getGenTime() {
        return this.genTime;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    public BOOLEAN getOrdering() {
        return this.ordering;
    }

    public INTEGER getNonce() {
        return this.nonce;
    }

    public GeneralName getTsa() {
        return this.tsa;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("version: " + this.version.getValueAsString());
        w.newLine();
        w.write("policy id: " + this.policy.getOID());
        w.newLine();
        this.messageImprint.dump(w);
        w.newLine();
        w.write("serial number: " + this.serialNumber.getValueAsString());
        w.newLine();
        w.write("generation time: " + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.genTime.getDate()));
        if (this.accuracy != null) {
            w.newLine();
            this.accuracy.dump(w);
        }
        w.newLine();
        w.write("ordering: " + this.ordering.getValueAsString());
        if (this.nonce != null) {
            w.newLine();
            w.write("nonce: " + this.nonce.getValueAsString());
        }
        if (this.tsa != null) {
            w.newLine();
            this.tsa.dump(w);
        }
        if (this.extensions != null) {
            w.newLine();
            this.extensions.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

