/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.ESSCertID;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.PolicyInformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SigningCertificate
extends ANY
implements Dumpable {
    private List<ESSCertID> certs;
    private List<PolicyInformation> policies;

    public SigningCertificate(Run _run, Version version) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int certsend = _run.readLength();
        certsend += _run.pos();
        this.certs = new ArrayList<ESSCertID>();
        while (_run.pos() < certsend) {
            ESSCertID essCertID = new ESSCertID(_run, version);
            this.certs.add(essCertID);
        }
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int polend = _run.readLength();
        polend += _run.pos();
        this.policies = new ArrayList<PolicyInformation>();
        while (_run.pos() < polend) {
            PolicyInformation policy = new PolicyInformation(_run);
            this.policies.add(policy);
        }
    }

    public List<ESSCertID> getCertIDs() {
        return this.certs;
    }

    public List<PolicyInformation> getPolicyInformation() {
        return this.policies;
    }

    public boolean matches(Certificate signingCertificate) {
        for (ESSCertID essCertID : this.getCertIDs()) {
            if (!essCertID.matches(signingCertificate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        for (ESSCertID essCertID : this.certs) {
            essCertID.dump(w);
        }
        if (this.policies != null) {
            for (PolicyInformation pi : this.policies) {
                pi.dump(w);
            }
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public static enum Version {
        V1,
        V2;

    }
}

