/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.PKIFailureInfo;
import de.bos_bremen.ci.asn1.tsp.PKIFreeText;
import de.bos_bremen.ci.asn1.tsp.PKIStatus;
import java.io.IOException;

public class PKIStatusInfo
extends ANY
implements Dumpable {
    PKIStatus status;
    PKIFreeText statusString;
    PKIFailureInfo failInfo;

    public PKIStatusInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.status = new PKIStatus(_run);
        if (_run.pos() < end && (tag = _run.get()) == 48) {
            this.statusString = new PKIFreeText(_run);
        }
        if (_run.pos() < end) {
            this.failInfo = new PKIFailureInfo(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.status.toString());
        w.newLine();
        if (this.statusString != null) {
            w.newLine();
            this.statusString.dump(w);
        }
        if (this.failInfo != null) {
            w.newLine();
            this.failInfo.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

