/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTF8String;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PKIFreeText
extends ANY {
    public static final String OID = "1.3.6.1.5.5.7.0.9";
    private List<UTF8String> texts;

    public PKIFreeText(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() < end) {
            this.texts = new ArrayList<UTF8String>();
        }
        while (_run.pos() < end) {
            UTF8String s = new UTF8String(_run);
            this.texts.add(s);
        }
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        int i = this.texts.size() - 1;
        for (UTF8String s : this.texts) {
            w.write(s.getValue());
            if (--i < 0) continue;
            w.newLine();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

