/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class PKIFailureInfo
extends BITSTRING
implements Dumpable {
    public static final int flagcount = 8;
    public static final int badAlg = 0;
    public static final int badRequest = 2;
    public static final int badDataFormat = 5;
    public static final int timeNotAvailable = 14;
    public static final int unacceptedPolicy = 15;
    public static final int unacceptedExtension = 16;
    public static final int addInfoNotAvailable = 17;
    public static final int systemFailure = 25;

    public PKIFailureInfo(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PKIFailureInfo[");
        boolean b = false;
        for (int i = 0; i < 8; ++i) {
            if (!this.is(i)) continue;
            if (b) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append(PKIFailureInfo.toString(i));
            b = true;
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(int flag) {
        switch (flag) {
            case 0: {
                return "badAlg";
            }
            case 2: {
                return "badRequest";
            }
            case 5: {
                return "badDataFormat";
            }
            case 14: {
                return "timeNotAvailable";
            }
            case 15: {
                return "unacceptedPolicy";
            }
            case 16: {
                return "unacceptedExtension";
            }
            case 17: {
                return "addInfoNotAvailable";
            }
            case 25: {
                return "systemFailure";
            }
        }
        return "unknown flag \"" + flag + "\"";
    }
}

