/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class MessageImprint
extends ANY
implements Dumpable {
    AlgorithmIdentifier hashAlgorithm;
    OCTETSTRING hashedMessage;

    public MessageImprint(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.hashAlgorithm = new AlgorithmIdentifier(_run);
        this.hashedMessage = new OCTETSTRING(_run);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public OCTETSTRING getHashedMessage() {
        return this.hashedMessage;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.hashAlgorithm.dump(w);
        w.newLine();
        w.write("hashed message: ");
        w.write(this.hashedMessage.getValueAsString());
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

