/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.tsp.Hash;
import de.bos_bremen.ci.asn1.tsp.SigningCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ESSCertID
extends ANY
implements Dumpable,
Flattable {
    public static final AlgorithmIdentifier SHA1;
    public static final AlgorithmIdentifier SHA256;
    private AlgorithmIdentifier algorithIdentifier;
    private Hash certHash;
    private IssuerSerial issuerSerial;

    public ESSCertID(Run _run, SigningCertificate.Version version) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.algorithIdentifier = _run.get() == 48 ? new AlgorithmIdentifier(_run) : this.getDefaultDigestAlgorithmFor(version);
        this.certHash = new Hash(_run);
        if (_run.pos() < end) {
            this.issuerSerial = new IssuerSerial(_run);
        }
    }

    private AlgorithmIdentifier getDefaultDigestAlgorithmFor(SigningCertificate.Version version) throws ParseException {
        if (version == SigningCertificate.Version.V1) {
            return SHA1;
        }
        if (version == SigningCertificate.Version.V2) {
            return SHA256;
        }
        throw new ParseException("Incorrect version " + (Object)((Object)version));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithIdentifier;
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public Hash getCertHash() {
        return this.certHash;
    }

    public boolean matches(Certificate certificate) {
        byte[] certHash;
        String algorithmName = this.getAlgorithmIdentifier().getAlgorithmName();
        byte[] freshlyCalculatedCertHash = certificate.getFingerprint(algorithmName);
        if (!MessageDigest.isEqual(freshlyCalculatedCertHash, certHash = this.getCertHash().getOctets())) {
            return false;
        }
        if (this.getIssuerSerial() != null) {
            BigInteger serial = this.getIssuerSerial().getSerialnumber().getValue();
            BigInteger certSerial = certificate.getSerialNumber().getValue();
            if (!certSerial.equals(serial)) {
                return false;
            }
            GeneralNames issuer = this.getIssuerSerial().getIssuer();
            if (!issuer.matches(certificate)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        if (this.algorithIdentifier != null) {
            w.newLine();
            this.algorithIdentifier.dump(w);
        }
        w.newLine();
        w.write("certificate hash: " + this.certHash.getValueAsString());
        if (this.issuerSerial != null) {
            w.newLine();
            this.issuerSerial.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(null, null));
        result.add(new Flattable.Pair(res.getString("certificateHash"), this.certHash.getValueAsString()));
        if (this.issuerSerial != null) {
            result.add(new Flattable.Pair(null, null));
            result.add(new Flattable.Pair(res.getString("issuerdn"), null));
            result.addAll(this.issuerSerial.flatten(res, false));
        }
        if (this.algorithIdentifier != null) {
            result.add(new Flattable.Pair(null, null));
            result.addAll(this.algorithIdentifier.flatten(res, false));
        }
        return result;
    }

    static {
        try {
            SHA1 = AlgorithmIdentifier.valueOf(AlgorithmService.getDigestForName((String)"SHA1").getOID());
            SHA256 = AlgorithmIdentifier.valueOf(AlgorithmService.getDigestForName((String)"SHA256").getOID());
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot create algorithm identifier SHA1 and/or SHA256", e);
        }
    }
}

