/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.ContentType;
import java.io.IOException;

public abstract class ContentInfo
extends ANY
implements Dumpable {
    ContentType contentType;
    ANY content;

    public ContentInfo(Run _run) throws ParseException {
        super(_run, false);
        byte b;
        int end;
        byte tag = _run.next();
        if (!this.implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean indef = len == -1;
        int n = end = indef ? -1 : _run.pos() + len;
        if (!indef) {
            this.setEnd(end);
        }
        this.contentType = new ContentType(_run);
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTaggedConstructed(tag)) {
            byte b2;
            _run.next();
            int len2 = _run.readLength();
            boolean indef2 = len2 == -1;
            this.content = this.generateContent(this.contentType, _run);
            if (indef2 && (b2 = _run.get()) == 0) {
                _run.next();
                _run.next();
            }
        }
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            this.setEnd(_run.pos());
        }
    }

    protected abstract ANY generateContent(ContentType var1, Run var2) throws ParseException;

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(ContentType.nameFor(this.contentType) + " (" + this.contentType + ")");
        if (this.content != null) {
            w.newLine();
            if (this.content instanceof Dumpable) {
                ((Dumpable)((Object)this.content)).dump(w);
            } else {
                w.write(this.content.toString());
            }
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public OBJECTIDENTIFIER getContentType() {
        return this.contentType;
    }

    public ANY getContent() {
        return this.content;
    }
}

