/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.tsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class Accuracy
extends ANY
implements Dumpable {
    INTEGER seconds;
    INTEGER millis;
    INTEGER micros;

    public Accuracy(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 2) {
            this.seconds = new INTEGER(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            this.millis = new INTEGER(_run, true);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            this.micros = new INTEGER(_run, true);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        if (this.seconds != null) {
            w.newLine();
            w.write("seconds: " + this.seconds);
        }
        if (this.millis != null) {
            w.newLine();
            w.write("millis: " + this.millis);
        }
        if (this.micros != null) {
            w.newLine();
            w.write("micros: " + this.micros);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public INTEGER getSeconds() {
        return this.seconds;
    }

    public INTEGER getMillis() {
        return this.millis;
    }

    public INTEGER getMicros() {
        return this.micros;
    }
}

