/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.ocsp.CertID;
import de.bos_bremen.ci.asn1.ocsp.CertStatus;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.ext.CertHashExtension;
import java.io.IOException;

public class SingleResponse
extends ANY
implements Dumpable {
    private CertID certID;
    private CertStatus certStatus;
    private GeneralizedTime thisUpdate;
    private GeneralizedTime nextUpdate;
    private Extensions singleExtensions;

    public SingleResponse(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setLength(run.readLength());
        this.certID = new CertID(run);
        this.certStatus = new CertStatus(run);
        this.thisUpdate = new GeneralizedTime(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        byte tag = run.next();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            run.readLength();
            this.nextUpdate = new GeneralizedTime(run);
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            run.readLength();
            this.singleExtensions = new Extensions(run);
        }
    }

    public CertID getCertID() {
        return this.certID;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public GeneralizedTime getThisUpdate() {
        return this.thisUpdate;
    }

    public GeneralizedTime getNextUpdate() {
        return this.nextUpdate;
    }

    public Extensions getSingleExtensions() {
        return this.singleExtensions;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        this.certID.dump(w);
        w.newLine();
        this.certStatus.dump(w);
        w.newLine();
        w.write("thisUpdate: ");
        w.write(this.thisUpdate.getDate().toString());
        w.newLine();
        w.write("nextUpdate: ");
        w.write(this.nextUpdate != null && this.nextUpdate.getDate() != null ? this.nextUpdate.getDate().toString() : "no date");
        if (this.singleExtensions != null) {
            w.newLine();
            this.singleExtensions.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public boolean existsCertHashExtension() {
        return this.singleExtensions == null ? false : this.singleExtensions.contains("1.3.36.8.3.13");
    }

    public boolean isCertHashValid(Certificate certificate) {
        boolean result = false;
        if (this.existsCertHashExtension()) {
            CertHashExtension certHashExtension = this.singleExtensions.get(CertHashExtension.class, "1.3.36.8.3.13");
            result = certHashExtension == null ? false : certHashExtension.isCertHashValid(certificate);
        }
        return result;
    }
}

