/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.x509.CRLReason;
import java.io.IOException;

public class RevokedInfo
extends ANY
implements Dumpable {
    private GeneralizedTime revocationTime;
    private CRLReason revocationReason;

    public RevokedInfo(Run run) throws ParseException {
        this(run, false);
    }

    public RevokedInfo(Run run, boolean implicit) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (!implicit && tag != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setLength(run.readLength());
        this.revocationTime = new GeneralizedTime(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        if (!ASN1.Factory.isTaggedConstructedAs(run.next(), 0)) {
            throw new ParseException(this, "Expected tagged constructed 0", run.pos());
        }
        run.readLength();
        this.revocationReason = new CRLReason(run);
    }

    public GeneralizedTime getRevocationTime() {
        return this.revocationTime;
    }

    public CRLReason getRevocationReason() {
        return this.revocationReason;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        w.write("revocationTime: ");
        w.write(this.revocationTime.getDate().toString());
        if (this.revocationReason != null) {
            w.newLine();
            this.revocationReason.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write("}");
    }
}

