/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.crl.CertificateList;
import de.bos_bremen.ci.asn1.ocsp.BasicOCSPResponse;
import de.bos_bremen.ci.asn1.ocsp.OtherRevVals;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RevocationValues
extends ANY
implements Dumpable {
    private List<CertificateList> crlVals = new ArrayList<CertificateList>();
    private List<BasicOCSPResponse> ocspVals = new ArrayList<BasicOCSPResponse>();
    private OtherRevVals otherRevVals;

    public RevocationValues() throws ParseException {
        this((List<BasicOCSPResponse>)null);
    }

    public RevocationValues(List<BasicOCSPResponse> basicOCSPresponses) throws ParseException {
        super(Run.create(new BSource(new byte[]{48, 0})), false);
        if (basicOCSPresponses != null) {
            this.ocspVals.addAll(basicOCSPresponses);
        }
    }

    public RevocationValues(Run run) throws ParseException {
        super(run, false);
        int end;
        if (RevocationValues.initSequence(this, run)) {
            run.next();
            return;
        }
        byte tag = run.next();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            run.readLength();
            if (run.next() != 48) {
                throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
            }
            end = run.readLength() + run.pos();
            while (run.pos() < end) {
                this.crlVals.add(new CertificateList(run, false));
            }
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            run.readLength();
            if (run.next() != 48) {
                throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
            }
            end = run.readLength() + run.pos();
            while (run.pos() < end) {
                this.ocspVals.add(new BasicOCSPResponse(run));
            }
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedAs(tag, 2)) {
            run.readLength();
            this.otherRevVals = new OtherRevVals(run);
        }
    }

    public List<CertificateList> getCrlVals() {
        return this.crlVals;
    }

    public List<BasicOCSPResponse> getOcspVals() {
        return this.ocspVals;
    }

    public List<CertificateList> getCrlVals(Certificate certificate) {
        ArrayList<CertificateList> result = new ArrayList<CertificateList>();
        if (certificate != null) {
            for (CertificateList crlVal : this.getCrlVals()) {
                if (!crlVal.matches(certificate)) continue;
                result.add(crlVal);
            }
        }
        return result;
    }

    public List<BasicOCSPResponse> getOcspVals(FlatCertificate certificate) {
        ArrayList<BasicOCSPResponse> result = new ArrayList<BasicOCSPResponse>();
        if (certificate != null) {
            for (BasicOCSPResponse ocspVal : this.getOcspVals()) {
                if (!ocspVal.matches(certificate)) continue;
                result.add(ocspVal);
            }
        }
        return result;
    }

    public OtherRevVals getOtherRevVals() {
        return this.otherRevVals;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        if (this.crlVals != null) {
            w.newLine();
            w.write("crlVals[" + this.crlVals.size() + "]:");
            w.indent();
            for (CertificateList crlVal : this.crlVals) {
                w.newLine();
                crlVal.dump(w);
            }
            w.outdent();
        }
        if (this.ocspVals != null) {
            w.newLine();
            w.write("ocspVals[" + this.ocspVals.size() + "]:");
            w.indent();
            for (BasicOCSPResponse ocspVal : this.ocspVals) {
                w.newLine();
                ocspVal.dump(w);
            }
            w.outdent();
        }
        if (this.otherRevVals != null) {
            w.newLine();
            w.indent();
            this.otherRevVals.dump(w);
            w.outdent();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public static RevocationValues merge(RevocationValues oneRevocationValues, RevocationValues anotherRevocationValues) {
        RevocationValues mergedRevocationValues = RevocationValues.add(null, oneRevocationValues);
        return RevocationValues.add(mergedRevocationValues, anotherRevocationValues);
    }

    public static RevocationValues add(RevocationValues mergeRevocationValues, RevocationValues revocationValues) {
        RevocationValues lMergeRevocationValues;
        try {
            lMergeRevocationValues = mergeRevocationValues == null ? new RevocationValues() : mergeRevocationValues;
        }
        catch (ParseException e) {
            return null;
        }
        if (revocationValues != null && revocationValues.getOcspVals() != null && !revocationValues.getOcspVals().isEmpty()) {
            lMergeRevocationValues.getOcspVals().addAll(revocationValues.getOcspVals());
        }
        return lMergeRevocationValues;
    }
}

