/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.ocsp.CertID;
import de.bos_bremen.ci.asn1.ocsp.ResponderID;
import de.bos_bremen.ci.asn1.ocsp.SingleResponse;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.Version;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class ResponseData
extends ANY
implements Dumpable {
    private Version version;
    private ResponderID responderID;
    private GeneralizedTime producedAt;
    private List<SingleResponse> responses = new ArrayList<SingleResponse>();
    private Extensions responseExtensions;

    public ResponseData(Run run) throws ParseException {
        super(run, false);
        if (ResponseData.initSequence(this, run)) {
            run.next();
            return;
        }
        if (ASN1.Factory.isTaggedConstructedAs(run.get(), 0)) {
            run.next();
            run.readLength();
            this.version = new Version(run);
        } else {
            this.version = new Version(0);
        }
        this.responderID = new ResponderID(run);
        this.producedAt = new GeneralizedTime(run);
        run.next();
        int end = run.readLength() + run.pos();
        while (run.pos() < end) {
            this.responses.add(new SingleResponse(run));
        }
        if (run.pos() < this.getEnd()) {
            if (!ASN1.Factory.isTaggedConstructedAs(run.next(), 1)) {
                throw new ParseException(this, "Tagged constructed 1 expected", run.pos());
            }
            run.readLength();
            this.responseExtensions = new Extensions(run);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public GeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    public List<SingleResponse> getResponses() {
        return this.responses;
    }

    public Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        w.write("Version: ");
        w.write(this.version.getValueAsString());
        w.newLine();
        this.responderID.dump(w);
        w.newLine();
        w.write("producedAt: ");
        w.write(this.producedAt.getValueAsString());
        w.newLine();
        w.write("responses[" + this.responses.size() + "]: ");
        w.indent();
        for (SingleResponse response : this.responses) {
            w.newLine();
            response.dump(w);
        }
        w.outdent();
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public SingleResponse getSingleResponse(FlatCertificate certificate) {
        int idx = this.getSingleResponseIndex(certificate);
        if (idx >= 0 && idx < this.responses.size()) {
            return this.responses.get(idx);
        }
        return null;
    }

    public int getSingleResponseIndex(FlatCertificate certificate) {
        try {
            BigInteger searchSerialNumber = certificate.getSerialNumber().getValue();
            byte[] searchIssuerNameBytes = certificate.getIssuer().getEncoded();
            MessageDigest md = null;
            for (SingleResponse response : this.responses) {
                byte[] issuerNameHash;
                DigestAlgorithm digestAlgorithm;
                byte[] searchIssuerNameHash;
                CertID certID = response.getCertID();
                if (!searchSerialNumber.equals(certID.getSerialNumber().getValue()) || !MessageDigest.isEqual(searchIssuerNameHash = (md = MessageDigest.getInstance((digestAlgorithm = AlgorithmService.getDigestForOID((String)certID.getHashAlgorithm().getOID().getOID())).getJCAName())).digest(searchIssuerNameBytes), issuerNameHash = certID.getIssuerNameHash().getValueAsByteArray())) continue;
                return this.responses.indexOf(response);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public boolean isCertHashValid(Certificate certificate) {
        SingleResponse singleResponse = this.getSingleResponse(certificate);
        return singleResponse == null ? false : singleResponse.isCertHashValid(certificate);
    }
}

