/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.IOException;

public class ResponderID
extends ANY
implements Dumpable {
    private Name byName;
    private OCTETSTRING byKey;

    public ResponderID(Run run) throws ParseException {
        byte tag = run.next();
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            run.readLength();
            this.byName = new Name(run);
        } else if (ASN1.Factory.isTaggedAs(tag, 2)) {
            run.readLength();
            this.byKey = new OCTETSTRING(run);
        } else {
            throw new ParseException("ResponderID: Expected tagged object with tag number 1 or 2");
        }
    }

    public Name getName() {
        return this.byName;
    }

    public OCTETSTRING getKeyHash() {
        return this.byKey;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        if (this.byName != null) {
            w.newLine();
            w.write("byName: ");
            w.write(this.byName.getAsDirectoryString());
        }
        if (this.byKey != null) {
            w.newLine();
            w.write("byKey: ");
            w.write(this.byKey.getValueAsString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public String toString() {
        return "ResponderID[\"" + (this.byKey != null ? this.byKey : this.byName) + "\"]";
    }
}

