/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.CIDump;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.ocsp.BasicOCSPResponse;
import de.bos_bremen.ci.asn1.ocsp.SingleResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class OCSPResponse
extends ANY
implements Dumpable {
    public static final OBJECTIDENTIFIER OID_OCSP_RESPONSE = OBJECTIDENTIFIER.valueOf("1.3.6.1.5.5.7.16.2");
    public static final int SUCCESSFUL = 0;
    public static final int MALFORMED_REQUEST = 1;
    public static final int INTERNAL_ERROR = 2;
    public static final int TRY_LATER = 3;
    public static final int SIG_REQUIRED = 5;
    public static final int UNAUTHORIZED = 6;
    private final int code;
    private final OBJECTIDENTIFIER identifier;
    private final ANY response;
    private final BasicOCSPResponse basicOCSPresponse;

    public static String toString(int code) {
        switch (code) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "malformed request";
            }
            case 2: {
                return "internal error";
            }
            case 3: {
                return "try later";
            }
            case 5: {
                return "sig required";
            }
            case 6: {
                return "unauthorized";
            }
        }
        return "unknown code";
    }

    public int getCode() {
        return this.code;
    }

    public OBJECTIDENTIFIER getIdentifier() {
        return this.identifier;
    }

    public OCSPResponse(Run run) throws ParseException {
        super(run, false);
        if (OCSPResponse.initSequence(this, run)) {
            this.code = 2;
            this.identifier = null;
            this.response = null;
            this.basicOCSPresponse = null;
            run.next();
            return;
        }
        byte tag = run.next();
        if (ASN1.Factory.isTaggedConstructed(tag)) {
            throw new UnexpectedASN1ObjectException((ANY)this, 32, run.pos());
        }
        run.readLength();
        this.code = run.next();
        tag = run.next();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            run.readLength();
            if (run.next() != 48) {
                throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
            }
            run.readLength();
            this.identifier = new OBJECTIDENTIFIER(run);
            if (BasicOCSPResponse.OID_BASIC_OCSP_RESPONSE.equals(this.identifier)) {
                this.basicOCSPresponse = new BasicOCSPResponse(Run.create(new BSource(new OCTETSTRING(run).getValueAsByteArray())));
                this.response = this.basicOCSPresponse;
                OCSPResponse.dumpBasicOCSPResponses(this.basicOCSPresponse);
            } else {
                this.response = new ANY(Run.create(new BSource(new OCTETSTRING(run).getValueAsByteArray())), true);
                this.basicOCSPresponse = null;
            }
        } else {
            this.identifier = null;
            this.response = null;
            this.basicOCSPresponse = null;
        }
    }

    public ANY getResponse() {
        return this.response;
    }

    public BasicOCSPResponse getBasicOCSPResponse() {
        return this.basicOCSPresponse;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("code: " + OCSPResponse.toString(this.code));
        if (this.identifier != null) {
            w.newLine();
            w.write("identifier: " + this.identifier.getOID());
        }
        if (this.response instanceof Dumpable) {
            w.newLine();
            ((Dumpable)((Object)this.response)).dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public static void dumpBasicOCSPResponses(BasicOCSPResponse ... basicOCSPResponses) {
        OCSPResponse.dumpBasicOCSPResponses(Arrays.asList(basicOCSPResponses));
    }

    public static void dumpBasicOCSPResponses(List<BasicOCSPResponse> dumpVals) {
        if (CIDump.isDumpEnabled() && dumpVals != null) {
            for (int i = 0; i < dumpVals.size(); ++i) {
                BasicOCSPResponse dumpVal = dumpVals.get(i);
                System.out.println("OCSPVal #" + i);
                for (SingleResponse sr : dumpVal.getTbsResponseData().getResponses()) {
                    System.out.println("--" + sr.getCertID().getSerialNumber());
                }
            }
        }
    }
}

