/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.ocsp.RevokedInfo;
import java.io.IOException;
import java.security.cert.CRLReason;
import java.util.Date;

public class CertStatus
extends ANY
implements Dumpable {
    private int tagNo;
    private ANY any;

    public CertStatus(Run run) throws ParseException {
        super(run, true);
        byte tag = run.get();
        if (!ASN1.Factory.isTagged(tag)) {
            throw new ParseException(this, "Tag expected", run.pos());
        }
        this.tagNo = ASN1.Factory.getTagNumber(tag);
        switch (this.tagNo) {
            case 0: {
                this.any = new NULL(run, true);
                break;
            }
            case 1: {
                this.any = new RevokedInfo(run, true);
                break;
            }
            case 2: {
                this.any = new NULL(run, true);
                break;
            }
            default: {
                throw new ParseException(this, "Unknown tag number " + this.tagNo, run.pos());
            }
        }
    }

    public boolean isGood() {
        return this.tagNo == 0;
    }

    public boolean isRevoked() {
        return this.tagNo == 1;
    }

    public boolean isUnknown() {
        return this.tagNo == 2;
    }

    public ANY getStatusObject() {
        return this.any;
    }

    public NULL getGoodInfo() {
        if (this.isGood()) {
            return (NULL)NULL.class.cast(this.any);
        }
        return null;
    }

    public RevokedInfo getRevokedInfo() {
        if (this.isRevoked()) {
            return (RevokedInfo)RevokedInfo.class.cast(this.any);
        }
        return null;
    }

    public NULL getUnknownInfo() {
        if (this.isUnknown()) {
            return (NULL)NULL.class.cast(this.any);
        }
        return null;
    }

    public Date getRevocationTime() {
        RevokedInfo revokedInfo = this.getRevokedInfo();
        if (revokedInfo == null) {
            return null;
        }
        return revokedInfo.getRevocationTime().getDate();
    }

    public de.bos_bremen.ci.asn1.x509.CRLReason getRevocationReason() {
        RevokedInfo revokedInfo = this.getRevokedInfo();
        if (revokedInfo == null) {
            return null;
        }
        return revokedInfo.getRevocationReason();
    }

    public CRLReason getJavaRevocationReason() {
        RevokedInfo revokedInfo = this.getRevokedInfo();
        if (revokedInfo == null) {
            return null;
        }
        de.bos_bremen.ci.asn1.x509.CRLReason revocationReason = revokedInfo.getRevocationReason();
        return revocationReason == null ? null : revocationReason.getReason();
    }

    @Override
    public String getValueAsString() {
        return this.isGood() ? "good" : (this.isRevoked() ? "revoked" : (this.isUnknown() ? "unknown" : super.getValueAsString()));
    }

    @Override
    public String toString() {
        return "CertStatus: " + this.getValueAsString();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        w.write("status: ");
        w.write(this.getValueAsString());
        if (this.any instanceof Dumpable) {
            w.newLine();
            ((Dumpable)((Object)this.any)).dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

