/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import java.io.IOException;

public class CertID
extends ANY
implements Dumpable {
    private AlgorithmIdentifier hashAlgorithm;
    private OCTETSTRING issuerNameHash;
    private OCTETSTRING issuerKeyHash;
    private CertificateSerialNumber serialNumber;

    public CertID(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setLength(run.readLength());
        this.hashAlgorithm = new AlgorithmIdentifier(run);
        this.issuerNameHash = new OCTETSTRING(run);
        this.issuerKeyHash = new OCTETSTRING(run);
        this.serialNumber = new CertificateSerialNumber(run);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public OCTETSTRING getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public OCTETSTRING getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public CertificateSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        w.write("hashAlgorithm: ");
        w.write(this.hashAlgorithm.getAlgorithmName());
        w.newLine();
        w.write("issuerNameHash: ");
        w.write(this.issuerNameHash.getValueAsHexedString());
        w.newLine();
        w.write("issuerKeyHash: ");
        w.write(this.issuerKeyHash.getValueAsHexedString());
        w.newLine();
        w.write("serialNumber: ");
        w.write(this.serialNumber.getValueAsString());
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

