/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.ocsp;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.ocsp.ResponderID;
import de.bos_bremen.ci.asn1.ocsp.ResponseData;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;

public class BasicOCSPResponse
extends ANY
implements Dumpable {
    public static final OBJECTIDENTIFIER OID_BASIC_OCSP_RESPONSE = OBJECTIDENTIFIER.valueOf("1.3.6.1.5.5.7.48.1.1");
    private ResponseData tbsResponseData;
    private AlgorithmIdentifier signatureAlgorithm;
    private BITSTRING signature;
    private List<FlatCertificate> certs = new ArrayList<FlatCertificate>();

    public BasicOCSPResponse(Run run) throws ParseException {
        super(run, false);
        if (BasicOCSPResponse.initSequence(this, run)) {
            run.next();
            return;
        }
        this.tbsResponseData = new ResponseData(run);
        this.signatureAlgorithm = new AlgorithmIdentifier(run);
        this.signature = new BITSTRING(run);
        if (run.pos() < this.getEnd()) {
            if (!ASN1.Factory.isTaggedConstructedAs(run.next(), 0)) {
                throw new ParseException(this, "Tagged constructed 0 expected", run.pos());
            }
            run.readLength();
            if (run.next() != 48) {
                throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
            }
            int certsEnd = run.readLength() + run.pos();
            while (run.pos() < certsEnd) {
                this.certs.add(FlatCertificate.Factory.generateCertificate(run));
            }
        }
    }

    public ResponseData getTbsResponseData() {
        return this.tbsResponseData;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public BITSTRING getSignature() {
        return this.signature;
    }

    public List<FlatCertificate> getCerts() {
        return this.certs;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(" {");
        w.indent();
        w.newLine();
        this.tbsResponseData.dump(w);
        w.newLine();
        w.write("signatureAlgorithm: ");
        w.write(this.signatureAlgorithm.getAlgorithmName());
        w.newLine();
        w.write("signature: ");
        w.write(this.signature.getValueAsString());
        if (this.certs != null) {
            w.newLine();
            w.write("certs[" + this.certs.size() + "] {");
            w.indent();
            for (FlatCertificate cert : this.certs) {
                w.newLine();
                cert.dump(w);
            }
            w.newLine();
            w.outdent();
            w.write(125);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public boolean verify() throws ParseException, GeneralSecurityException, IOException {
        return this.verify(null);
    }

    public boolean verify(String sigProvider) throws ParseException, GeneralSecurityException, IOException {
        return this.verify(this.getSignerCertificate(sigProvider), sigProvider);
    }

    public Certificate getSignerCertificate(String sigProvider) throws GeneralSecurityException {
        FlatCertificate flatCertificate;
        try {
            flatCertificate = this.getFlatCertificate(sigProvider);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        if (flatCertificate == null) {
            throw new GeneralSecurityException("no matching ocsp signer certificate found at certificates of response");
        }
        if (!Certificate.class.isInstance(flatCertificate)) {
            throw new GeneralSecurityException("no matching ocsp signer certificate found at certificates of response");
        }
        return (Certificate)Certificate.class.cast(flatCertificate);
    }

    public FlatCertificate getFlatCertificate(String sigProvider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] keyDigestValue;
        ResponderID responderID = this.tbsResponseData.getResponderID();
        Name responderName = responderID.getName();
        OCTETSTRING keyHash = responderID.getKeyHash();
        byte[] byArray = keyDigestValue = keyHash == null ? null : keyHash.getValueAsByteArray();
        if (responderName == null && keyHash == null) {
            throw new IOException("responderID contains nothing (one of name or hash is required)");
        }
        if (responderName != null && keyHash != null) {
            throw new IOException("responderID contains name and hash (only one of name or hash is permitted)");
        }
        MessageDigest messageDigest = null;
        if (keyHash != null) {
            messageDigest = sigProvider == null || sigProvider.isEmpty() ? MessageDigest.getInstance("SHA1") : MessageDigest.getInstance("SHA1", sigProvider);
        }
        FlatCertificate c = null;
        for (FlatCertificate cert : this.certs) {
            if (cert != null && keyHash != null && MessageDigest.isEqual(keyDigestValue, messageDigest.digest(cert.getEncoded()))) {
                c = cert;
                break;
            }
            if (cert == null || responderName == null || !responderName.equals(cert.getSubject())) continue;
            c = cert;
            break;
        }
        return c;
    }

    public boolean verify(Certificate certificate, String sigProvider) throws ParseException, GeneralSecurityException, IOException {
        return this.verify(certificate.getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey(), sigProvider);
    }

    public boolean verify(PublicKey key, String sigProvider) throws ParseException, GeneralSecurityException, IOException {
        String jcaName = this.getSignatureAlgorithm().getJCAName();
        Signature sig = sigProvider == null ? Signature.getInstance(jcaName) : Signature.getInstance(jcaName, sigProvider);
        sig.initVerify(key);
        sig.update(this.tbsResponseData.getEncoded());
        return sig.verify(this.signature.getValueAsByteArray());
    }

    public List<Certificate> getCertificateChain(Certificate certificate) {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        result.add(certificate);
        Certificate tmp = certificate;
        while ((tmp = this.getIssuerCertificate(tmp)) != null) {
            result.add(tmp);
            if (!tmp.getIssuer().equals(tmp.getSubject())) continue;
            break;
        }
        return result;
    }

    public Certificate getIssuerCertificate(Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        List<FlatCertificate> certs = this.getCerts();
        if (certs != null) {
            for (FlatCertificate cert : certs) {
                if (!Certificate.class.isInstance(cert)) continue;
                Certificate cc = (Certificate)Certificate.class.cast(cert);
                if (!certificate.getIssuer().equals(cc.getSubject())) continue;
                return cc;
            }
        }
        return null;
    }

    public boolean matches(FlatCertificate certificate) {
        return this.tbsResponseData == null ? false : this.tbsResponseData.getSingleResponse(certificate) != null;
    }
}

