/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.esf;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.ocsp.ResponderID;
import java.io.IOException;

public class OcspIdentifier
extends ANY
implements Dumpable {
    private ResponderID responderID = null;
    private GeneralizedTime producedAt = null;

    public OcspIdentifier(Run run) throws ParseException {
        super(run, false);
        if (OcspIdentifier.initSequence(this, run)) {
            return;
        }
        this.responderID = new ResponderID(run);
        this.producedAt = new GeneralizedTime(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        run.next();
    }

    public ResponderID getResponderID() {
        return this.responderID;
    }

    public GeneralizedTime getProducedAt() {
        return this.producedAt;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.responderID.dump(w);
        w.newLine();
        w.write("producedAt: " + this.producedAt.getDate());
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

