/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.esf;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.esf.CrlListID;
import de.bos_bremen.ci.asn1.esf.OcspListID;
import de.bos_bremen.ci.asn1.esf.OtherRevRefs;
import java.io.IOException;

public class CrlOcspRef
extends ANY
implements Dumpable {
    CrlListID crlListID = null;
    OcspListID ocspListID = null;
    private OtherRevRefs otherRevRefs;

    public CrlOcspRef(Run run) throws ParseException {
        super(run, false);
        if (CrlOcspRef.initSequence(this, run)) {
            return;
        }
        byte tag = run.next();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            run.readLength();
            this.crlListID = new CrlListID(run);
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            run.readLength();
            this.ocspListID = new OcspListID(run);
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedAs(tag, 2)) {
            run.readLength();
            this.otherRevRefs = new OtherRevRefs(run);
            if (run.pos() >= this.getEnd()) {
                return;
            }
            tag = run.next();
        }
    }

    public CrlListID getCrlids() {
        return this.crlListID;
    }

    public OcspListID getOcspids() {
        return this.ocspListID;
    }

    public ANY getOtherRev() {
        return this.otherRevRefs;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        if (this.crlListID != null) {
            w.newLine();
            this.crlListID.dump(w);
        }
        if (this.ocspListID != null) {
            w.newLine();
            this.ocspListID.dump(w);
        }
        if (this.otherRevRefs != null) {
            w.newLine();
            this.otherRevRefs.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

