/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.esf;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTCTime;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.IOException;

public class CrlIdendifier
extends ANY
implements Dumpable {
    private GeneralName crlIssuer = null;
    private UTCTime crlIssuedTime = null;
    private INTEGER crlNumber = null;

    public CrlIdendifier(Run run) throws ParseException {
        super(run, false);
        if (CrlIdendifier.initSequence(this, run)) {
            return;
        }
        this.crlIssuer = new Name(run);
        this.crlIssuedTime = new UTCTime(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        this.crlNumber = new INTEGER(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        run.next();
    }

    public GeneralName getCrlIssuer() {
        return this.crlIssuer;
    }

    public UTCTime getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public INTEGER getCrlNumber() {
        return this.crlNumber;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("crlIssuer: " + this.crlIssuer.getDisplayName());
        w.newLine();
        w.write("crlIssuedTime: " + this.crlIssuedTime.getDate());
        if (this.crlNumber != null) {
            w.newLine();
            w.write("crlNumber: " + this.crlNumber.getValue());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

