/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.er;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.er.ArchiveTimestampChain;
import de.bos_bremen.ci.asn1.er.EncryptionInfo;
import de.bos_bremen.ci.asn1.x509.Attribute;
import java.util.ArrayList;
import java.util.List;

public class EvidenceRecord
extends ANY {
    private static final ASN1Consumer<AlgorithmIdentifier> DIGEST_ALGORITUM_IDENTIFIER_CONSUMER = new ASN1Consumer<AlgorithmIdentifier>(){

        @Override
        public AlgorithmIdentifier consume(Run _run) throws ParseException {
            return new AlgorithmIdentifier(_run);
        }
    };
    private static final ASN1Consumer<Attribute> ATTRIBUTE_CONSUMER = new ASN1Consumer<Attribute>(){

        @Override
        public Attribute consume(Run _run) throws ParseException {
            return new Attribute(_run);
        }
    };
    private static final ASN1Consumer<ArchiveTimestampChain> ARCHIVE_TIMESTAMP_SEQUENCE_CONSUMER = new ASN1Consumer<ArchiveTimestampChain>(){

        @Override
        public ArchiveTimestampChain consume(Run _run) throws ParseException {
            return new ArchiveTimestampChain(_run);
        }
    };
    private INTEGER version;
    private List<AlgorithmIdentifier> digestAlgorithms;
    private List<Attribute> cryptoInfos;
    private EncryptionInfo encryptionInfo;
    private List<ArchiveTimestampChain> archiveTimeStampSequence;
    private boolean internal;

    public EvidenceRecord(Run _run, boolean internal) throws ParseException {
        super(_run, false);
        this.internal = internal;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + ", found: 0x" + Hex.hexify(tag), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.version = new INTEGER(_run);
        GenericSequence<AlgorithmIdentifier> digestAlgSequence = new GenericSequence<AlgorithmIdentifier>(_run, DIGEST_ALGORITUM_IDENTIFIER_CONSUMER);
        this.digestAlgorithms = digestAlgSequence.getElements();
        tag = _run.get();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            _run.readLength();
            GenericSequence<Attribute> cryptoInfosSequence = new GenericSequence<Attribute>(_run, ATTRIBUTE_CONSUMER);
            this.cryptoInfos = cryptoInfosSequence.getElements();
            tag = _run.get();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            _run.readLength();
            this.encryptionInfo = new EncryptionInfo(_run);
        }
        GenericSequence<ArchiveTimestampChain> archiveTimestampChainSequence = new GenericSequence<ArchiveTimestampChain>(_run, ARCHIVE_TIMESTAMP_SEQUENCE_CONSUMER);
        this.archiveTimeStampSequence = archiveTimestampChainSequence.getElements();
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public List<AlgorithmIdentifier> getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public List<Attribute> getCryptoInfos() {
        return this.cryptoInfos;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.encryptionInfo;
    }

    public List<ArchiveTimestampChain> getArchiveTimeStampSequence() {
        return this.archiveTimeStampSequence;
    }

    public boolean isInternal() {
        return this.internal;
    }

    private class GenericSequence<T>
    extends ANY {
        private List<T> elements;

        public GenericSequence(Run _run, ASN1Consumer<T> producer) throws ParseException {
            super(_run, true);
            this.elements = new ArrayList<T>();
            if (GenericSequence.initSequence(this, _run)) {
                return;
            }
            while (_run.pos() < this.getEnd()) {
                this.elements.add(producer.consume(_run));
            }
            if (_run.pos() >= this.getEnd()) {
                return;
            }
            _run.next();
        }

        public List<T> getElements() {
            return this.elements;
        }
    }

    private static interface ASN1Consumer<T> {
        public T consume(Run var1) throws ParseException;
    }
}

