/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.er;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;

public class EncryptionInfo
extends ANY {
    private OBJECTIDENTIFIER oid;
    private byte[] value;

    public EncryptionInfo(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos() + ", found: 0x" + Hex.hexify(tag), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        this.oid = new OBJECTIDENTIFIER(run);
        this.value = ASN1.Factory.generate(run).getEncoded();
    }

    public OBJECTIDENTIFIER getOid() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.value;
    }
}

