/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.er;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.er.ArchiveTimestamp;
import java.util.ArrayList;
import java.util.List;

public class ArchiveTimestampChain
extends ANY {
    private List<ArchiveTimestamp> timestamps;

    public ArchiveTimestampChain(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos() + ", found: 0x" + Hex.hexify(tag), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        this.timestamps = new ArrayList<ArchiveTimestamp>();
        while (run.pos() < this.getEnd()) {
            this.timestamps.add(new ArchiveTimestamp(run));
        }
        if (run.pos() >= this.getEnd()) {
            return;
        }
        run.next();
    }

    public List<ArchiveTimestamp> getTimestamps() {
        return this.timestamps;
    }
}

