/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.er;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.util.OctetStringSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchiveTimestamp
extends ANY {
    private AlgorithmIdentifier digestAlgorithm;
    private Map<OBJECTIDENTIFIER, List<SignedAttribute>> attributes;
    private List<List<OCTETSTRING>> reducedHashtree;
    private de.bos_bremen.ci.asn1.cms.ArchiveTimestamp timestamp;

    public ArchiveTimestamp(Run run) throws ParseException {
        super(run, true);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos() + ", found: 0x" + Hex.hexify(tag), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        tag = run.get();
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            run.next();
            run.readLength();
            tag = run.get();
            if (tag == 6) {
                this.digestAlgorithm = new AlgorithmIdentifier(new OBJECTIDENTIFIER(run), null);
                tag = run.get();
                if (tag == 5) {
                    new NULL(run);
                }
            } else {
                this.digestAlgorithm = new AlgorithmIdentifier(run);
            }
            tag = run.get();
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            run.readLength();
            AttributeSet attributeSet = new AttributeSet(run);
            this.attributes = attributeSet.getAttributes();
            tag = run.get();
        }
        if (ASN1.Factory.isTaggedAs(tag, 2)) {
            run.next();
            int seqEnd = run.pos() + run.readLength();
            this.reducedHashtree = new ArrayList<List<OCTETSTRING>>();
            while (run.pos() < seqEnd) {
                this.reducedHashtree.add(new OctetStringSequence(run).getData());
            }
            tag = run.get();
        }
        this.timestamp = new de.bos_bremen.ci.asn1.cms.ArchiveTimestamp(run, 1);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Map<OBJECTIDENTIFIER, List<SignedAttribute>> getAttributes() {
        return this.attributes;
    }

    public List<List<OCTETSTRING>> getReducedHashtree() {
        return this.reducedHashtree;
    }

    public de.bos_bremen.ci.asn1.cms.ArchiveTimestamp getTimestamp() {
        return this.timestamp;
    }

    private class AttributeSet
    extends ANY {
        private Map<OBJECTIDENTIFIER, List<SignedAttribute>> attributes;

        public AttributeSet(Run run) throws ParseException {
            super(run, false);
            byte tag = run.next();
            if (tag != 49) {
                throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + run.pos(), run.pos());
            }
            this.attributes = new HashMap<OBJECTIDENTIFIER, List<SignedAttribute>>();
            int end = run.readLength();
            this.setEnd(end += run.pos());
            while (run.pos() < end) {
                SignedAttribute a = new SignedAttribute(run);
                List<SignedAttribute> list = this.attributes.get(a.getType());
                if (list == null) {
                    list = new ArrayList<SignedAttribute>();
                    this.attributes.put(a.getType(), list);
                }
                this.attributes.get(a.getType()).add(a);
            }
        }

        public Map<OBJECTIDENTIFIER, List<SignedAttribute>> getAttributes() {
            return this.attributes;
        }
    }
}

