/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.crl;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.crl.RevokedCertificate;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.Version;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class TBSCertList
extends ANY
implements Dumpable,
Flattable {
    Version version;
    AlgorithmIdentifier signature;
    Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    List<RevokedCertificate> revokedCertificates;
    Extensions crlExtensions;

    public TBSCertList(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        this.version = tag == 2 ? new Version(_run) : new Version(0);
        this.signature = new AlgorithmIdentifier(_run);
        this.issuer = new Name(_run);
        this.thisUpdate = Time.Factory.generate(_run);
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 23 || tag == 24) {
            this.nextUpdate = Time.Factory.generate(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (_run.pos() >= end) {
            return;
        }
        if (tag == 48) {
            _run.next();
            int rcEnd = _run.readLength();
            rcEnd += _run.pos();
            this.revokedCertificates = new ArrayList<RevokedCertificate>();
            while (_run.pos() < rcEnd) {
                RevokedCertificate rc = new RevokedCertificate(_run);
                this.revokedCertificates.add(rc);
            }
        }
        if (ASN1.Factory.isTagged(tag = _run.get()) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.crlExtensions = new Extensions(_run);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public List<RevokedCertificate> getRevokedCertificates() {
        return this.revokedCertificates;
    }

    public Extensions getCrlExtensions() {
        return this.crlExtensions;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.getVersion().toString());
        w.newLine();
        this.getSignature().dump(w);
        w.newLine();
        this.getIssuer().dump(w);
        w.newLine();
        w.write("thisUpdate: " + this.getThisUpdate().toString());
        w.newLine();
        if (this.getNextUpdate() != null) {
            w.write("nextUpdate: " + this.getNextUpdate().toString());
            w.newLine();
        }
        if (this.getRevokedCertificates() != null && !this.getRevokedCertificates().isEmpty()) {
            w.write("RevokedCertificates {");
            w.indent();
            for (RevokedCertificate rc : this.getRevokedCertificates()) {
                w.newLine();
                rc.dump(w);
            }
        }
        if (this.getCrlExtensions() != null) {
            w.newLine();
            this.getCrlExtensions().dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(res.getString("general.type"), "CRL"));
        pairs.add(new Flattable.Pair(res.getString("general.version"), this.version.getValue().toString()));
        pairs.add(new Flattable.Pair(res.getString("general.signaturealgorithm"), this.signature.getAlgorithmName()));
        DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
        pairs.add(new Flattable.Pair(res.getString("general.thisUpdate"), sdf.format(this.thisUpdate.getDate())));
        if (this.getNextUpdate() != null) {
            pairs.add(new Flattable.Pair(res.getString("general.nextUpdate"), sdf.format(this.getNextUpdate().getDate())));
        }
        if (this.getRevokedCertificates() != null && !this.getRevokedCertificates().isEmpty()) {
            pairs.add(new Flattable.Pair(null, null));
            pairs.add(new Flattable.Pair(res.getString("revokedCertificates"), null));
            for (RevokedCertificate rc : this.getRevokedCertificates()) {
                pairs.addAll(rc.flatten(res, _short));
                pairs.add(new Flattable.Pair(null, null));
            }
        }
        if (this.getCrlExtensions() != null) {
            pairs.addAll(this.getCrlExtensions().flatten(res, _short));
        }
        return pairs;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }
}

