/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.crl;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class RevokedCertificate
extends ANY
implements Dumpable,
Flattable,
Comparable<RevokedCertificate> {
    CertificateSerialNumber userCertificate;
    Time revocationDate;
    Extensions crlEntryExtensions;

    public RevokedCertificate(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.userCertificate = new CertificateSerialNumber(_run);
        this.revocationDate = Time.Factory.generate(_run);
        if (_run.pos() >= end) {
            return;
        }
        this.crlEntryExtensions = new Extensions(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("userCertificate: " + this.getUserCertificateSerialNumbner().getValueAsHexedString());
        w.newLine();
        w.write(" revocationDate: " + this.getRevocationDate().toString());
        if (this.getCRLEntryExtensions() != null) {
            w.newLine();
            this.getCRLEntryExtensions().dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
        pairs.add(new Flattable.Pair(res.getString("certificate"), this.getUserCertificateSerialNumbner().getValueAsHexedString() + res.getString("revokedCertificate.binder") + sdf.format(this.getRevocationDate().getDate())));
        if (this.getCRLEntryExtensions() != null) {
            pairs.addAll(this.getCRLEntryExtensions().flatten(res, _short));
        }
        return pairs;
    }

    public INTEGER getUserCertificateSerialNumbner() {
        return this.userCertificate;
    }

    public Time getRevocationDate() {
        return this.revocationDate;
    }

    public Extensions getCRLEntryExtensions() {
        return this.crlEntryExtensions;
    }

    @Override
    public int compareTo(RevokedCertificate _o) {
        return this.revocationDate.getDate().compareTo(_o.getRevocationDate().getDate());
    }

    @Override
    public byte[] getEncoded() {
        Run run = Run.create(this.getSource(), this.getOffset());
        return run.next(this.getLength());
    }
}

