/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.crl;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.crl.CertificateList;
import de.bos_bremen.ci.asn1.crl.OtherRevocationInfoFormat;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RevocationInfoChoices
extends ANY
implements Set<RevocationInfoChoice> {
    private Set<RevocationInfoChoice> revocationInfoChoices;

    public RevocationInfoChoices(Run run, boolean implicit) throws ParseException {
        super(run, implicit);
        int end;
        byte b = run.next();
        if (!implicit && b != 49) {
            throw new UnexpectedASN1ObjectException(this, 49, b, run.pos());
        }
        int len = run.readLength();
        boolean indef = len == -1;
        int n = end = indef ? -1 : run.pos() + len;
        if (!indef) {
            this.setEnd(end);
        }
        this.revocationInfoChoices = new HashSet<RevocationInfoChoice>();
        while (indef || this.getEnd() > run.pos()) {
            this.revocationInfoChoices.add(RevocationInfoChoice.Factory.generate(run));
            if (!indef || (b = run.get()) != 0) continue;
            run.next();
            run.next();
            return;
        }
    }

    public List<CertificateList> getCertificatesLists() {
        if (this.revocationInfoChoices == null) {
            return new ArrayList<CertificateList>();
        }
        ArrayList<CertificateList> result = new ArrayList<CertificateList>();
        for (RevocationInfoChoice revocationInfoChoice : this.revocationInfoChoices) {
            if (!(revocationInfoChoice instanceof CertificateList)) continue;
            result.add((CertificateList)revocationInfoChoice);
        }
        return result;
    }

    public List<OtherRevocationInfoFormat> getOtherRevocationInfoFormats(OBJECTIDENTIFIER formatIdentifier) {
        if (this.revocationInfoChoices == null) {
            return new ArrayList<OtherRevocationInfoFormat>();
        }
        ArrayList<OtherRevocationInfoFormat> result = new ArrayList<OtherRevocationInfoFormat>();
        for (RevocationInfoChoice revocationInfoChoice : this.revocationInfoChoices) {
            if (!(revocationInfoChoice instanceof OtherRevocationInfoFormat)) continue;
            OtherRevocationInfoFormat otherRevocationInformat = (OtherRevocationInfoFormat)revocationInfoChoice;
            if (formatIdentifier != null && !formatIdentifier.equals(otherRevocationInformat.getOtherRevInfoFormat())) continue;
            result.add(otherRevocationInformat);
        }
        return result;
    }

    @Override
    public int size() {
        return this.revocationInfoChoices.size();
    }

    @Override
    public boolean isEmpty() {
        return this.revocationInfoChoices.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.revocationInfoChoices.contains(o);
    }

    @Override
    public Iterator<RevocationInfoChoice> iterator() {
        return this.revocationInfoChoices.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.revocationInfoChoices.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.revocationInfoChoices.toArray(a);
    }

    @Override
    public boolean add(RevocationInfoChoice e) {
        return this.revocationInfoChoices.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.revocationInfoChoices.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.revocationInfoChoices.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends RevocationInfoChoice> c) {
        return this.revocationInfoChoices.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.revocationInfoChoices.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.revocationInfoChoices.removeAll(c);
    }

    @Override
    public void clear() {
        this.revocationInfoChoices.clear();
    }
}

