/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.crl;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoice;
import de.bos_bremen.ci.asn1.ocsp.BasicOCSPResponse;
import de.bos_bremen.ci.asn1.ocsp.OCSPResponse;

public class OtherRevocationInfoFormat
extends ANY
implements RevocationInfoChoice {
    private OBJECTIDENTIFIER otherRevInfoFormat;
    private ANY otherRevInfo;

    public OtherRevocationInfoFormat(Run run, boolean implicit) throws ParseException {
        super(run, implicit);
        byte b = run.next();
        if (!implicit && b != 48) {
            throw new UnexpectedASN1ObjectException(this, 48, b, run.pos());
        }
        this.setLength(run.readLength());
        this.otherRevInfoFormat = new OBJECTIDENTIFIER(run);
        if (OCSPResponse.OID_OCSP_RESPONSE.getOID().equals(this.otherRevInfoFormat.getOID())) {
            this.otherRevInfo = new OCSPResponse(run);
        } else if (BasicOCSPResponse.OID_BASIC_OCSP_RESPONSE.getOID().equals(this.otherRevInfoFormat.getOID())) {
            this.otherRevInfo = new BasicOCSPResponse(run);
        } else {
            this.otherRevInfo = new ANY(run, false);
            run.next();
            int otherRevInfoLength = run.readLength();
            this.otherRevInfo.setLength(otherRevInfoLength);
            run.skip(otherRevInfoLength);
        }
    }

    public OBJECTIDENTIFIER getOtherRevInfoFormat() {
        return this.otherRevInfoFormat;
    }

    public ANY getOtherRevInfo() {
        return this.otherRevInfo;
    }
}

