/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.crl;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoice;
import de.bos_bremen.ci.asn1.crl.TBSCertList;
import de.bos_bremen.ci.asn1.x509.Certificate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class CertificateList
extends ANY
implements Dumpable,
Flattable,
RevocationInfoChoice {
    TBSCertList tbsCertList;
    AlgorithmIdentifier signatureAlgorithm;
    BITSTRING signatureValue;

    public CertificateList(File _file) throws ParseException, IOException {
        this(new BSource(_file));
    }

    public CertificateList(InputStream _is) throws ParseException, IOException {
        this(new BSource(_is));
    }

    public CertificateList(Source _source) throws ParseException {
        this(Run.create(_source), false);
    }

    public CertificateList(Run _run, boolean implicit) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.tbsCertList = new TBSCertList(_run);
        this.signatureAlgorithm = new AlgorithmIdentifier(_run);
        this.signatureValue = new BITSTRING(_run);
    }

    public TBSCertList getTBSCertList() {
        return this.tbsCertList;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public BITSTRING getSignatureValue() {
        return this.signatureValue;
    }

    @Override
    public byte[] getEncoded() {
        Run run = Run.create(this.getSource(), this.getOffset());
        return run.next(this.getLength());
    }

    public boolean verify(PublicKey _key, String _sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature v = null;
        v = _sigProvider == null ? Signature.getInstance(this.getSignatureAlgorithm().getJCAName()) : Signature.getInstance(this.getSignatureAlgorithm().getJCAName(), _sigProvider);
        v.initVerify(_key);
        if (!this.getSignatureAlgorithm().getAlgorithmName().equals(this.getTBSCertList().getSignature().getAlgorithmName())) {
            throw new CRLException("signature algorithm in TBS cert not same as outer cert");
        }
        v.update(this.getTBSCertList().asByteArray());
        return v.verify(this.getSignatureValue().getValueAsByteArray());
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.getTBSCertList().dump(w);
        w.newLine();
        this.getSignatureAlgorithm().dump(w);
        w.newLine();
        w.write("Signature: ");
        w.write(this.getSignatureValue().getValueAsString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public String toString() {
        ResourceBundle bundle = ResourceBundle.getBundle(Flattable.class.getName(), Locale.getDefault());
        List<Flattable.Pair> pairs = this.flatten(bundle, false);
        int indent = 0;
        for (Flattable.Pair pair : pairs) {
            if (pair.label == null) continue;
            indent = Math.max(pair.label.length(), indent);
        }
        StringWriter w = new StringWriter();
        Iterator<Flattable.Pair> iterator = pairs.iterator();
        while (iterator.hasNext()) {
            Flattable.Pair pair = iterator.next();
            w.write(pair.toString(indent));
            if (!iterator.hasNext()) continue;
            w.write(10);
        }
        return w.toString();
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.addAll(this.tbsCertList.flatten(res, _short));
        if (!_short) {
            pairs.add(new Flattable.Pair(res.getString("issuersignature"), null));
            pairs.add(new Flattable.Pair(res.getString("general.signaturealgorithm"), this.signatureAlgorithm.getAlgorithmName()));
            pairs.add(new Flattable.Pair(res.getString("general.signature"), this.signatureValue.getValueAsString()));
            pairs.add(new Flattable.Pair(null, null));
        }
        return pairs;
    }

    public boolean matches(Certificate certificate) {
        return false;
    }
}

