/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DirectoryString;
import java.util.ArrayList;
import java.util.List;

public class SignerLocation
extends ANY {
    private CharString countryName;
    private CharString localityName;
    private List<CharString> postalAddress = new ArrayList<CharString>();

    public SignerLocation(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        if (run.pos() >= end) {
            return;
        }
        tag = run.next();
        if (ASN1.Factory.isTaggedConstructedAs(tag, 0)) {
            run.readLength();
            this.countryName = DirectoryString.Factory.createDirectoryString(run);
            if (run.pos() >= end) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedConstructedAs(tag, 1)) {
            run.readLength();
            this.localityName = DirectoryString.Factory.createDirectoryString(run);
            if (run.pos() >= end) {
                return;
            }
            tag = run.next();
        }
        if (ASN1.Factory.isTaggedConstructedAs(tag, 2)) {
            run.readLength();
            tag = run.next();
            if (tag != 48) {
                throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + run.pos(), run.pos());
            }
            run.readLength();
            while (run.pos() < end) {
                this.postalAddress.add(DirectoryString.Factory.createDirectoryString(run));
            }
            if (this.postalAddress.size() > 6) {
                throw new ParseException(this, "postalAddress must contain at least 6 strings", run.pos());
            }
        }
    }

    public CharString getCountryName() {
        return this.countryName;
    }

    public String getCountryNameAsString() {
        return this.countryName != null ? this.countryName.getValueAsString() : null;
    }

    public CharString getLocalityName() {
        return this.localityName;
    }

    public String getLocalityNameAsString() {
        return this.localityName != null ? this.localityName.getValueAsString() : null;
    }

    public List<CharString> getPostalAddress() {
        return this.postalAddress;
    }

    public int getPostalAddressCount() {
        return this.postalAddress.size();
    }

    public String getPostalAddressAsString(int index) {
        return this.getPostalAddress().get(index).getValueAsString();
    }
}

