/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SignerInfos
extends ANY {
    private List<SignerInfo> signerInfo;

    public SignerInfos(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.signerInfo = new ArrayList<SignerInfo>();
        if (end == -1) {
            while (_run.get() != 0) {
                SignerInfo si = new SignerInfo(_run);
                this.signerInfo.add(si);
            }
            _run.next();
            _run.next();
            return;
        }
        this.setEnd(end += _run.pos());
        while (_run.pos() < end) {
            SignerInfo si = new SignerInfo(_run);
            this.signerInfo.add(si);
        }
    }

    public int size() {
        return this.signerInfo.size();
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.signerInfo.isEmpty()) {
            w.indent();
            w.newLine();
            int i = 0;
            for (SignerInfo si : this.signerInfo) {
                si.dump(w);
                if (++i != this.signerInfo.size()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    public List<SignerInfo> getSignerInfos() {
        return this.signerInfo;
    }
}

