/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.CipherAlgorithm;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.FormatAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.LengthOutputStream;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.cms.CMSVersion;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ci.asn1.cms.SignatureValue;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignerIdentifier;
import de.bos_bremen.ci.asn1.cms.UnsignedAttributes;
import de.bos_bremen.ci.asn1.tsp.ESSCertID;
import de.bos_bremen.ci.asn1.tsp.MessageImprint;
import de.bos_bremen.ci.asn1.tsp.TSTInfo;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.KeyPurposeId;
import de.bos_bremen.ci.asn1.x509.ext.ExtendedKeyUsageExtension;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.List;

public class SignerInfo
extends ANY
implements Dumpable {
    CMSVersion version;
    SignerIdentifier sid;
    AlgorithmIdentifier digestAlgorithm;
    SignedAttributes signedAttrs;
    AlgorithmIdentifier digestEncryptionAlgorithm;
    SignatureValue signature;
    UnsignedAttributes unsignedAttrs;
    private AlgorithmIdentifier signatureAlgorithmIdentifier = null;

    public SignerInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + " (RFC5652, section 5.1), found: 0x" + Hex.hexify(tag), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.version = new CMSVersion(_run);
        this.sid = SignerIdentifier.Factory.generate(_run);
        this.digestAlgorithm = new AlgorithmIdentifier(_run);
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            this.signedAttrs = new SignedAttributes(_run, true);
        }
        this.digestEncryptionAlgorithm = new AlgorithmIdentifier(_run);
        this.signature = new SignatureValue(_run);
        if (_run.pos() < end && ASN1.Factory.isTagged(tag = _run.get()) && (tag & 0xF) == 1) {
            this.unsignedAttrs = new UnsignedAttributes(_run, true);
        }
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public ANY getSignedAttributeValue(OBJECTIDENTIFIER oid) {
        return this.signedAttrs == null ? null : this.signedAttrs.getValue(oid);
    }

    public List<? extends ANY> getSignedAttributeValues(OBJECTIDENTIFIER oid) {
        return this.signedAttrs == null ? null : this.signedAttrs.getValues(oid);
    }

    public ANY getUnsignedAttributeValue(OBJECTIDENTIFIER oid) {
        return this.unsignedAttrs == null ? null : this.unsignedAttrs.getValue(oid);
    }

    public List<? extends ANY> getUnsignedAttributeValues(OBJECTIDENTIFIER oid) {
        return this.unsignedAttrs == null ? null : this.unsignedAttrs.getValues(oid);
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.sid;
    }

    public SignedAttributes getSignedAttributes() {
        return this.signedAttrs;
    }

    public UnsignedAttributes getUnsignedAttributes() {
        return this.unsignedAttrs;
    }

    public SignerIdentifier getSid() {
        return this.sid;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        Algorithm algo = this.digestAlgorithm.getAlgorithm();
        if (SignatureAlgorithm.class.isInstance(algo)) {
            try {
                return AlgorithmIdentifier.valueOf((Algorithm)((SignatureAlgorithm)algo).getDigestAlgorithm());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.digestAlgorithm;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() throws NoSuchAlgorithmException, ParseException {
        if (this.signatureAlgorithmIdentifier == null) {
            String digestOID;
            PaddingAlgorithm paddingAlgorithm;
            SignatureAlgorithmBase base;
            SignatureAlgorithm signatureAlgorithm;
            if (SignatureAlgorithm.class.isInstance(this.digestEncryptionAlgorithm.getAlgorithm())) {
                DigestAlgorithm sigDigAlg;
                DigestAlgorithm digAlg;
                SignatureAlgorithm sigAlg = (SignatureAlgorithm)SignatureAlgorithm.class.cast(this.digestEncryptionAlgorithm.getAlgorithm());
                if (DigestAlgorithm.class.isInstance(this.digestAlgorithm.getAlgorithm()) && !(digAlg = (DigestAlgorithm)DigestAlgorithm.class.cast(this.digestAlgorithm.getAlgorithm())).equals(sigDigAlg = sigAlg.getDigestAlgorithm())) {
                    this.digestEncryptionAlgorithm = new AlgorithmIdentifier((Algorithm)AlgorithmService.getSignature((SignatureAlgorithmBase)sigAlg.getBaseAlgorithm(), (DigestAlgorithm)digAlg, (PaddingAlgorithm)sigAlg.getPaddingAlgorithm(), (FormatAlgorithm)sigAlg.getFormatAlgorithm()), this.digestEncryptionAlgorithm.getParameters());
                }
                this.signatureAlgorithmIdentifier = this.digestEncryptionAlgorithm;
                return this.digestEncryptionAlgorithm;
            }
            if (SignatureAlgorithm.class.isInstance(this.digestAlgorithm.getAlgorithm())) {
                this.signatureAlgorithmIdentifier = this.digestAlgorithm;
                return this.digestAlgorithm;
            }
            String cipherOID = this.digestEncryptionAlgorithm.getOID().getOID();
            List algorithms = AlgorithmService.getForOID((String)cipherOID);
            Algorithm algorithm = algorithms.size() == 0 ? null : (Algorithm)algorithms.get(0);
            FormatAlgorithm format = null;
            DigestAlgorithm lDigestAlgorithm = null;
            if (algorithm instanceof SignatureAlgorithm) {
                signatureAlgorithm = (SignatureAlgorithm)algorithm;
                base = signatureAlgorithm.getBaseAlgorithm();
                paddingAlgorithm = signatureAlgorithm.getPaddingAlgorithm();
                format = signatureAlgorithm.getFormatAlgorithm();
                String digestOID2 = this.digestAlgorithm.getOID().getOID();
                DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForOID((String)digestOID2);
                lDigestAlgorithm = signatureAlgorithm.getDigestAlgorithm().getName().equals(digestAlgorithm.getName()) ? signatureAlgorithm.getDigestAlgorithm() : digestAlgorithm;
            } else if (algorithm instanceof CipherAlgorithm) {
                base = SignatureAlgorithmBase.RSA;
                paddingAlgorithm = ((CipherAlgorithm)algorithm).getPaddingAlgorithm();
            } else {
                throw new NoSuchAlgorithmException("Unknown cipher algorithm with OID " + cipherOID);
            }
            if (lDigestAlgorithm == null && (lDigestAlgorithm = AlgorithmService.getDigestForOID((String)(digestOID = this.digestAlgorithm.getOID().getOID()))) == null) {
                throw new NoSuchAlgorithmException("Unknown digest algorithm with OID " + digestOID);
            }
            signatureAlgorithm = AlgorithmService.getSignature((SignatureAlgorithmBase)base, lDigestAlgorithm, (PaddingAlgorithm)paddingAlgorithm, (FormatAlgorithm)format);
            if (signatureAlgorithm == null || signatureAlgorithm.getOID() == null) {
                throw new NoSuchAlgorithmException("Unknown signature algorithm for " + lDigestAlgorithm.getOID() + ", " + cipherOID);
            }
            this.signatureAlgorithmIdentifier = new AlgorithmIdentifier((Algorithm)signatureAlgorithm, null);
        }
        return this.signatureAlgorithmIdentifier;
    }

    public SignatureValue getSignature() {
        return this.signature;
    }

    public int verify(Certificate certificate) {
        Time t;
        if (this.signedAttrs != null && (t = (Time)((Object)this.signedAttrs.getValue(SignedAttribute.signingTime))) != null) {
            Date date = t.getDate();
            if (date.before(certificate.getNotBefore())) {
                return -1;
            }
            if (date.after(certificate.getNotAfter())) {
                return 1;
            }
        }
        return 0;
    }

    public void validate(Certificate certificate, ESSCertID _certID, EncapsulatedContentInfo content, String sigProvider) throws ParseException, GeneralSecurityException, IOException {
        ExtendedKeyUsageExtension ext;
        AlgorithmIdentifier AlgorithmIdentifier2 = _certID.getAlgorithmIdentifier();
        if (AlgorithmIdentifier2 == null) {
            AlgorithmIdentifier2 = ESSCertID.SHA256;
        }
        if (!MessageDigest.isEqual(_certID.getCertHash().getOctets(), certificate.getFingerprint(AlgorithmIdentifier2.getOID().getOID()))) {
            throw new GeneralSecurityException("certificate hash does not match certID hash.");
        }
        if (_certID.getIssuerSerial() != null) {
            if (!_certID.getIssuerSerial().getSerialnumber().getValue().equals(certificate.getSerialNumber().getValue())) {
                throw new GeneralSecurityException("certificate serial number does not match certID for signature.");
            }
            if (!_certID.getIssuerSerial().getName().matches(certificate.getIssuer())) {
                throw new GeneralSecurityException("certificate name does not match certID for signature. ");
            }
        }
        ExtendedKeyUsageExtension extendedKeyUsageExtension = ext = certificate.getExtensions() == null ? null : (ExtendedKeyUsageExtension)certificate.getExtensions().get("2.5.29.37");
        if (ext == null || !ext.isCritical()) {
            throw new GeneralSecurityException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        List<KeyPurposeId> keyPurposeIDs = ext.getKeyPurposeIDs();
        if (keyPurposeIDs.size() != 1 && !keyPurposeIDs.get(0).equals(KeyPurposeId.id_kp_timeStamping)) {
            throw new GeneralSecurityException("ExtendedKeyUsage not solely time stamping.");
        }
        Date date = ((TSTInfo)content.getContent()).getGenTime().getDate();
        if (date.before(certificate.getNotBefore())) {
            throw new GeneralSecurityException("The token was generated before the certificate was valid");
        }
        if (date.after(certificate.getNotAfter())) {
            throw new GeneralSecurityException("The token was generated after the certificate was valid");
        }
        if (!this.verify(certificate.getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey(), content, sigProvider)) {
            throw new GeneralSecurityException("signature not created by certificate.");
        }
    }

    public boolean verify(Certificate certificate, EncapsulatedContentInfo content, String sigProvider) throws ParseException, GeneralSecurityException, IOException {
        Time t;
        if (this.signedAttrs != null && (t = (Time)((Object)this.signedAttrs.getValue(SignedAttribute.signingTime))) != null) {
            Date date = t.getDate();
            if (date.before(certificate.getNotBefore())) {
                throw new CertificateNotYetValidException();
            }
            if (date.after(certificate.getNotAfter())) {
                throw new CertificateExpiredException();
            }
        }
        PublicKey publicKey = certificate.getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey();
        return this.verify(publicKey, content, sigProvider);
    }

    public boolean verify(PublicKey key, EncapsulatedContentInfo content, String sigProvider) throws ParseException, GeneralSecurityException, IOException, NoSignedContentFoundException {
        String jcaName = this.getSignatureAlgorithm().getJCAName();
        Signature sig = sigProvider == null ? Signature.getInstance(jcaName) : Signature.getInstance(jcaName, sigProvider);
        sig.initVerify(key);
        if (this.signedAttrs != null) {
            byte[] hash;
            OCTETSTRING dig = (OCTETSTRING)this.signedAttrs.getValue(SignedAttribute.messageDigest);
            if (dig == null) {
                throw new SignatureException("no hash for content found in signed attributes");
            }
            if (content.getContentType().equals(ContentType.id_ct_TSTInfo)) {
                MessageImprint messageImprint = ((TSTInfo)content.getContent()).getMessageImprint();
                String digestAlgorithmName = messageImprint.getHashAlgorithm().getAlgorithmName();
                byte[] hashOfContentData = messageImprint.getHashedMessage().getOctets();
                if (content.getLinkedContent() != null) {
                    MessageDigest md = sigProvider == null ? MessageDigest.getInstance(digestAlgorithmName) : MessageDigest.getInstance(digestAlgorithmName, sigProvider);
                    DigestOutputStream os = new DigestOutputStream(new LengthOutputStream(), md);
                    content.writeContentOctets(os);
                    hash = md.digest();
                    if (!MessageDigest.isEqual(hash, hashOfContentData)) {
                        throw new SignatureException("hash of content file differs from message imprint");
                    }
                }
                hash = content.getDigest(this.digestAlgorithm.getAlgorithmName(), sigProvider);
            } else if (content.getLinkedContent() != null) {
                MessageDigest md = sigProvider == null ? MessageDigest.getInstance(this.digestAlgorithm.getAlgorithmName()) : MessageDigest.getInstance(this.digestAlgorithm.getAlgorithmName(), sigProvider);
                DigestOutputStream os = new DigestOutputStream(new LengthOutputStream(), md);
                content.writeContentOctets(os);
                hash = md.digest();
            } else {
                String jcaNameDigest = this.digestAlgorithm.getAlgorithmName();
                hash = content.getDigest(jcaNameDigest, sigProvider);
            }
            if (hash == null) {
                throw new NoSignedContentFoundException();
            }
            byte[] hash2 = dig.getOctets();
            if (!MessageDigest.isEqual(hash, hash2)) {
                throw new SignatureException("content hash found in signed attributes different");
            }
            OBJECTIDENTIFIER type = (OBJECTIDENTIFIER)this.signedAttrs.getValue(SignedAttribute.contentType);
            if (type == null) {
                throw new SignatureException("no content type id found in signed attributes");
            }
            if (!type.equals(content.getContentType())) {
                throw new SignatureException("contentType in signed attributes different");
            }
            byte[] bytes = this.signedAttrs.asByteArray();
            if (bytes.length > 0 && this.signedAttrs.isImplicit()) {
                bytes[0] = 49;
            }
            sig.update(bytes);
        } else if (content.getLinkedContent() != null) {
            content.writeContentOctets(sig);
        } else {
            content.writeContent(sig);
        }
        byte[] octets = this.signature.getOctets();
        return sig.verify(octets);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.version.toString());
        w.newLine();
        this.sid.dump(w);
        w.newLine();
        this.digestAlgorithm.dump(w);
        if (this.signedAttrs != null) {
            w.newLine();
            this.signedAttrs.dump(w);
        }
        w.newLine();
        this.digestEncryptionAlgorithm.dump(w);
        w.newLine();
        this.signature.dump(w);
        if (this.unsignedAttrs != null) {
            w.newLine();
            this.unsignedAttrs.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SignerInfo[");
        sb.append(this.digestAlgorithm.getAlgorithmName());
        sb.append(',');
        sb.append(' ');
        sb.append(this.digestEncryptionAlgorithm.getAlgorithmName());
        if (this.signedAttrs != null && this.signedAttrs.getValue(SignedAttribute.signingTime) != null) {
            sb.append(',');
            sb.append(' ');
            Time time = (Time)((Object)this.signedAttrs.getValue(SignedAttribute.signingTime));
            sb.append(time);
        }
        sb.append(']');
        return sb.toString();
    }

    public static class NoSignedContentFoundException
    extends SignatureException {
        private static final long serialVersionUID = -7111947805216230250L;

        public NoSignedContentFoundException() {
            super("no verifiable content present");
        }
    }
}

