/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CertifiedAttributesV2;
import de.bos_bremen.ci.asn1.cms.ClaimedAttributes;
import java.util.ArrayList;
import java.util.List;

public class SignerAttributeV2
extends ANY {
    private List<ClaimedAttributes> claimedAttributes = new ArrayList<ClaimedAttributes>();
    private List<CertifiedAttributesV2> certifiedAttributes = new ArrayList<CertifiedAttributesV2>();

    public SignerAttributeV2(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        this.setEnd(run.readLength() + run.pos());
        while (run.pos() < this.getEnd()) {
            byte tag = run.next();
            if (ASN1.Factory.isTaggedAs(tag, 0)) {
                run.readLength();
                this.claimedAttributes.add(new ClaimedAttributes(run));
                continue;
            }
            if (ASN1.Factory.isTaggedAs(tag, 1)) {
                run.readLength();
                this.certifiedAttributes.add(new CertifiedAttributesV2(run));
                continue;
            }
            if (ASN1.Factory.isTaggedAs(tag, 2)) {
                ASN1.Factory.generate(run);
                continue;
            }
            throw new ParseException(this, "Wrong tag number", run.pos());
        }
    }

    public List<ClaimedAttributes> getClaimedAttributes() {
        return this.claimedAttributes;
    }

    public List<CertifiedAttributesV2> getCertifiedAttributes() {
        return this.certifiedAttributes;
    }
}

